# -*- coding:utf-8 -*-
from features.Base_Features import BaseFeatures as BF
from service import Sql_complexOrder,Sql_contactsOperator
from service.Sql_RevealTheBottomChannel import *
import pandas as pd
import datetime

class __INIT__(BF):
    """兜底特征一期"""
    def __init__(self):
        time_now = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        BF._apply_at = time_now
        self._df_apply = pd.DataFrame()
        if self.orderId:
            BF._df_apply = getSql_userApplyQuotaRecord_apply_from(str(tuple([self.user_id])).replace(',)',')'))
            BF._df_apply_from = BF._df_apply.loc[BF._df_apply['order_no'] == self.orderId]
            _apply_from = BF._df_apply_from['apply_from'].values[0]
            BF._df_loan_apply = BF._df_apply.loc[BF._df_apply['apply_from'] == _apply_from]
            if self._df_apply_from.empty == False:
                BF._apply_at = datetime.datetime.strptime(BF._df_apply_from['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')

        BF.df_loan_all = getSql_loanAll(str(tuple([self.user_id])).replace(',)',')'))
        BF.df_loan_rollBack = pd.DataFrame()
        if BF.df_loan_all.empty == False:
            BF.df_loan_rollBack = Sql_complexOrder.get_Loan_rollBack(BF.df_loan_all,BF._apply_at)

class 进件订单所在渠道的未结清订单总数():
    """current_channel_unfinished_loan_cnt 进件订单所在渠道的未结清订单总数"""
    def feature(self):
        _进件订单所在渠道的未结清订单总数 = -9999999
        if self._df_loan_apply.empty == False:
            df_loan_apply = self._df_loan_apply
            loan_id = df_loan_apply['loan_id'].tolist()
            if self.df_loan_rollBack.empty == False:
                df_loan = self.df_loan_rollBack.loc[self.df_loan_rollBack['loan_id'].isin(loan_id)]
                if df_loan.empty == False:
                    df_loan_uncleared = df_loan.loc[df_loan['progress'] == 15]
                    _进件订单所在渠道的未结清订单总数 = len(set(df_loan_uncleared['loan_id']))
        self._result['进件订单所在渠道的未结清订单总数']['value'] = _进件订单所在渠道的未结清订单总数
        return self._result

class 进件订单在兜底渠道未结清订单总数():
    """bottom_channel_unfinished_loan_cnt  进件订单在兜底渠道未结清订单总数"""
    def feature(self):
        _进件订单在兜底渠道未结清订单总数 = -9999999
        if self.df_loan_rollBack.empty == False:
            df_loan = self.df_loan_rollBack.loc[self.df_loan_rollBack['business_type'] == 9]
            if df_loan.empty == False:
                df_loan_uncleared = df_loan.loc[(df_loan['progress'] == 15 )]
                _进件订单在兜底渠道未结清订单总数 = len(set(df_loan_uncleared['loan_id']))
        self._result['进件订单在兜底渠道未结清订单总数']['value'] = _进件订单在兜底渠道未结清订单总数
        return self._result


