import time
from handler.Base_Handler import BaseHandler
from config.csv_adapter import *
from config.mysql_adapter import *
from utils import JsonUtil
from handler.Features_old import *


class New_Audit(BaseHandler):
    def get(self):

        try:
            _business_type = self.get_argument('business_type', default=0)
            _uuid = self.get_argument('uuid', default=None)
            _orderId = self.get_argument('order_id', default=None)
            # _loanId = self.get_argument('loanId', default=None)

            if _uuid == None:
                self.write(JsonUtil.build_json_with_data(data=None))
                self.flush()
                self.finish()
            _result = new_audit(_uuid)
            self.write(JsonUtil.build_json_feature(data=_result))
            self.flush()
            self.finish()

        except ValueError as e:
            # == 数据类型或者字段缺少导致
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Param_Error, JsonUtil.Constants.Msg_Param_Error))
            self.flush()
        except Exception as e:
            # == 报异常，查询失败
            self.write(JsonUtil.build_json(JsonUtil.Constants.Code_Error, JsonUtil.Constants.Msg_Error))
            self.flush()

    pass

def new_audit(uuid = None):
    ret_j = {}
    ret_j["last_apply_loan_success"] = last_apply_loan_success(df_new_audit,uuid)[uuid]
    ret_j["last_loan_amount"] = last_loan_amount(df_new_audit,uuid)[uuid]
    ret_j["last_loan_overdue_days"] = last_loan_overdue_days(df_new_audit,uuid)[uuid]
    return ret_j
