# -*- coding:utf-8 -*-

'''
服务启动接口
'''
from socketserver import TCPServer

from tornado.web import Application
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
import tornado.log
import logging
import tornado.options
import config.settings as URL
# from handler import LoanDueRateHandler
from tornado.options import define, options

from handler import TransV2Read_Handler
from handler import NewAudit_Handler
from handler import Calc_Features_Handler  # 基础特征
from handler import ComplexOrder_Handler  # 多订单特征
from handler import LoanPostFeatures_Handler  # 催收模型特征

# settings = {'debug' : False}
class LogFormatter(tornado.log.LogFormatter):

    def __init__(self):
        print('%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s')
        super(LogFormatter, self).__init__(
            fmt='%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s',
            datefmt='%Y-%m-%d %H:%M:%S'
        )

def apps():
    return Application([
        (URL.url_trans_v2_read, TransV2Read_Handler.Trans_V2_Read),
        (URL.url_new_audit, NewAudit_Handler.New_Audit),
        (URL.url_calc_features, Calc_Features_Handler.CalcFeatures),
        (URL.url_complex_order, ComplexOrder_Handler.ComplexOrder),
        (URL.url_loanPostFeatures, LoanPostFeatures_Handler.loanPostFeatures)
    ])


if __name__ == "__main__":

    #
    # app = apps()
    # server = HTTPServer(app)
    # [i.setFormatter(LogFormatter()) for i in logging.getLogger().handlers]
    # tornado.options.parse_command_line()
    #
    # # #== 本地调试
    # app.listen(23010)
    # IOLoop.instance().start()


    from tornado.options import define, options
    define("port", default=23010, help="run on the given port ", type=int)
    define("log_path", default='/tmp', help="log path ", type=str)
    tornado.options.parse_command_line()
    app = apps()
    http_server = tornado.httpserver.HTTPServer(app)
    http_server.bind(options.port)
    http_server.start()  # num_processes=0  # tornado将按照cpu核数来fork进程
    tornado.ioloop.IOLoop.instance().start()
