# -*- coding:utf-8 -*-
import pandas as pd
from config.concat_sql import *
import re

def getSql_userAddress(user_id):
    """获取用户的通讯地址信息"""
    _sql = """
        SELECT
            user_id,
            province,
            city,
            district,
            address,
            CONCAT(province, city, district, address) addressDetail,
            CONCAT(province, city, district) address_province_city_district
        FROM
            xyqb_user_i_address
        WHERE
            user_id = {0}
        ORDER BY id DESC
        Limit 1
    """.format(user_id)
    _df = pd.read_sql(_sql,con_realtime)
    return _df

def get_AddresSplit(addres=''):
    """分割地址"""
    p = re.compile(r'省|直辖市|市|回族自治区|维吾尔自治区|壮族自治区|特别行政区|自治区|区|自治州|地区|县|盟|自治县')
    addres = re.split(p, addres)
    return addres


def getSql_mobileCallInfoDataService(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None):
    """ 移动通话记录 """
    _sql = """
      select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone from comservice_i_mobile_call_info
    """
    iswhere = []
    if user_phone:
        iswhere.append(' phone in {0}'.format(user_phone))
    elif contacts_phone:
        iswhere.append(" receiverPhone in {0}".format(contacts_phone))
    elif time_start:
        iswhere.append(" cTime >= '{0}'".format(contacts_phone))
    elif time_end:
        iswhere.append(" cTime <= '{0}'".format(contacts_phone))

    if iswhere:
        for i in range(len(iswhere)):
            if i ==0:
                _sql += ' where ' + iswhere[i]
            else:
                _sql += ' and '+iswhere[i]
    if contacts_phone:
        _sql = """
            select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_mobile_call_info force index(index_mobile_call_info_phone)
            where phone in {0}
            and receiverPhone in {1}
            and cTime  BETWEEN '{2}' and '{3}'
        """.format(user_phone,contacts_phone,time_start,time_end)
    else:
        _sql = """
            select uuid,cTime,tradeAddr,tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_mobile_call_info force index(index_mobile_call_info_phone)
            where phone in {0}
            and cTime  BETWEEN '{1}' and '{2}'
        """.format(user_phone,time_start,time_end)
    _df = pd.read_sql(_sql,con_comservice_v3)

    return _df

def getSql_telecomCallInfoDataService(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None):
    """ 电信通话记录 """
    if contacts_phone:
        _sql = """
            select uuid,cTime,tradeAddr,callWay as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_telecom_call_info force index(index_mobile_call_info_phone)
            where phone  in {0}
            and cTime  BETWEEN '{2}' and '{3}'
            and receiverPhone in {1}
        """.format(user_phone,time_start,time_end,contacts_phone)
    else:
        _sql = """
            select uuid,cTime,tradeAddr,callWay as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_telecom_call_info
            where phone  in {0}
            and cTime  BETWEEN '{1}' and '{2}'
        """.format(user_phone,time_start,time_end)

    _df = pd.read_sql(_sql,con_comservice_v3)
    return _df

def getSql_unicomCallInfoDataService(uuid = None,user_phone = None,contacts_phone = None,time_start = None,time_end = None):
    """ 联通通话记录 """
    if contacts_phone:
        _sql = """
            select uuid,cTime,tradeAddr,callType as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_unicom_call_info
            where phone  in {0}
             and receiverPhone in {1}
            and cTime  BETWEEN '{2}' and '{3}'
        """.format(user_phone,contacts_phone,time_start,time_end)

    else:
        _sql = """
            select uuid,cTime,tradeAddr,callType as tradeWay,tradeType,receiverPhone,tradeTime,phone
            from comservice_i_unicom_call_info
            where phone  in {0}
            and cTime  BETWEEN '{1}' and '{2}'
        """.format(user_phone,time_start,time_end)
    _df = pd.read_sql(_sql,con_comservice_v3)
    return _df

def get_splitSymbol(text):
    """删除字符串中的符号,重新拼装成字符串"""
    # pattern = r',|\.|/|;|\'|`|\[|\]|<|>|\?|:|"|\{|\}|\~|!|@|\$|%|\^|&|\(|\)|-|=|\+|，|。|、|；|‘|’|【|】|·|！|…|（|）0|1|2|3|4|5|6|7|8|9'
    # text_new = ''.join(re.split(pattern,text))
    # return text_new
    # 只保留中文
    pat=re.compile(r'[\u4e00-\u9fa5]+')
    result=''.join(pat.findall(text))
    return result