import pandas as pd
import datetime
from config.concat_sql import *

def getSql_loanAll(user_id):
    """获取用户所有放款订单明细"""
    _sql = """
        select
         IFNULL(aqr.order_no ,'') order_no
        ,loan.user_id,loan.id as loan_id,loan.progress,fest.contract_loan_amount,
        case when fest.loan_paid_at < aqr.apply_time then aqr.apply_time
			else fest.loan_paid_at  end as loan_paid_at
        ,case when loan.created_at >='2018-05-08' then aqr.apply_from
            when loan.created_at < '2018-05-08' then loan.created_from
            else null
            end as applied_from
        -- ,if (sub.created_at is not null, sub.created_at ,loan.created_at) apply_time
        ,case when loan.created_at >='2018-05-08' then aqr.apply_time
            when loan.created_at < '2018-05-08' then if (sub.created_at is not null, sub.created_at ,loan.created_at)
            else null
            end as apply_time
        ,plan.id as plan_id,plan.term_no, plan.repayment_status, plan.deadline as deadline,DATE_ADD(plan.deadline,INTERVAL 1 second) as deadline_new
        ,plan.repaid_at
        ,plan.current_repayment
        from loan_application_manifest_history as fest
        left join loan_application_history as loan on fest.loan_application_history_id = loan.id
        left join loan_submit_info as sub on sub.loan_id = loan.id
        left join repay as plan on plan.loan_application_history_id = loan.id
        left join repayment_record as record on record.repayment_plan_id = plan.id
        left join loan_account_ext as lae on lae.loan_id = loan.id
        left join apply_quota_record as aqr on aqr.order_no = lae.order_no
        where
        loan.user_id in {0}
        and loan.progress in (15,16,65)
        and fest.transaction_status in (2,5)
        order by loan.id,plan.id
    """.format(user_id)
    _df = pd.read_sql(_sql,con_tuomin_xyqb)
    return _df

def get_Loan_rollBack(df_loan,apply_time,passdueDay_Negative=False):
    """订单回滚"""
    df_loan['observationTime'] = apply_time
    # df_loan = df_loan.loc[(df_loan['apply_time'] < df_loan['observationTime']) & (df_loan['loan_paid_at'] < df_loan['observationTime'] )]

    df_loan['repaid_at'] = df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S'))
    df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
    df_loan['deadline'] = df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
    df_loan['apply_time'] = df_loan['apply_time'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S'))
    df_loan['passdue_day'] = 0
    # df_loan = df_loan.loc[(df_loan['apply_time'] <= df_loan['observationTime'])]
    df_loan = df_loan.loc[(df_loan['loan_paid_at'] < df_loan['observationTime'])]
    if df_loan.empty == False:
        df_loan.loc[(df_loan['repaid_at'] != '2000-01-01')&(df_loan['repaid_at']>df_loan['observationTime']),'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
        # 还款时间正常 ,还款状态!=3
        df_loan.loc[(df_loan['repaid_at'] != '2000-01-01') & (df_loan['repayment_status'] !=3),'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')
        df_loan.loc[(df_loan['repaid_at'] == '2000-01-01'),'repayment_status'] = 0
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')& (df_loan['repayment_status'] != 3),'repayment_status'] = 0

        df_loan.loc[(df_loan['repayment_status'] == 3),'passdue_day'] = (df_loan['repaid_at'] - df_loan['deadline']).dt.days
        df_loan.loc[(df_loan['repayment_status'] != 3)&(df_loan['observationTime'] > df_loan['deadline']) ,'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['repayment_status']==0)&(df_loan['observationTime']<df_loan['deadline']),'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] != '2000-01-01'),'passdue_day'] = (df_loan['repaid_at'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['observationTime'] > df_loan['deadline']) ,'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        # df_loan.loc[(df_loan['repaid_at'] == '2000-01-01')&(df_loan['repayment_status']==0)&(df_loan['observationTime']<df_loan['deadline']),'passdue_day'] = (df_loan['observationTime'] - df_loan['deadline']).dt.days
        if passdueDay_Negative == False:
            df_loan.loc[(df_loan['passdue_day'] < 0),'passdue_day'] = 0
        _loan_id = []

        for k ,v in df_loan.groupby(['loan_id']):
            _df = pd.DataFrame(v)
            if _df.loc[(_df['repayment_status']==3)]['plan_id'].count() != _df['plan_id'].count():
                _loan_id.append(k)
        _loan_id = list(set(_loan_id))
        if _loan_id:
            df_loan.loc[(df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
        else:
            df_loan['progress'] = 16
            # df_loan = df_loan
    return df_loan
