import pandas as pd
from config.concat_sql import *
import re
import requests
from utils.phone import *
from utils import tools
import datetime
from functools import reduce
from dateutil.relativedelta import relativedelta
import time
import numpy as np





def get_System_version(userid):
    """系统版本号"""
    Sql= """select userid,wifiIP,htime,osVersion from comservice_i_finger_print_info where userid = '{}' order by htime desc""".format(userid)
    _df = pd.read_sql(Sql, con=con_comservice_v3)
    return _df

# def get_if_apply_type_sql(order_id):
#     """查看类型是否是 首申 复审  复贷"""
#     Sql = '''SELECT user_id,order_no,applied_type from loan_application  where  order_no ='{}' '''.format(order_id)
#     _df = pd.read_sql(Sql, con=con_app_applied_type)
#     return _df


def get_if_apply_type_sql(uuid=None, order_no=None):
    """查看类型是否是 首申 复审  复贷"""

    params = {'user_uuid': str(uuid), 'codes': 'user_loan_type_v4',
              "order_id": str(order_no), "business_type": 0}
    headers = {
        'rc_auth_key': 'rc_offline',
        'rc_auth_secret': "9d9}bc24!e1z1x3`(x~4r29d$+45n3)'zb696b$85e>_]p2&4f{,a3~8b3e_ldt^"
    }
    _response = None
    try:
        _url = "http://172.20.1.184:23010/calc/features"
        _request = requests.get(_url, params=params, headers=headers)
        if _request.status_code == 200:
            _response = _request.json()
    except Exception as e:
        print(e.args)
    if _response:
        type_value = _response['data']['features']['user_loan_type_v4']['value']
        return type_value
    return None

def first_apply_sql(uuid):
    """首次申请"""
    Sql = '''select * from rc_user_behavior.`anti_fraud_log` where distinct_id = '{0}' and event in
     ('LoginAntiFraud','IDAntiFraud','OCRAntiFraud','OperatorAntiFraud','UserWishChangeTimes','TaobaoAntiFraud','ZhifubaoAntiFraud','BasicInfoAntiFraud')'''.format(uuid)
    _df = pd.read_sql(Sql, con=con_app_fraud)
    return _df

def second_apply_sql(uuid,first_time,last_time):
    """复申或者复贷"""
    Sql = '''select * from rc_user_behavior.`anti_fraud_log` where distinct_id = '{0}' and event in
         ('LoginAntiFraud','IDAntiFraud','OCRAntiFraud','OperatorAntiFraud','UserWishChangeTimes','TaobaoAntiFraud','ZhifubaoAntiFraud','BasicInfoAntiFraud') 
         and log_time >= '{1}' and log_time < '{2}' '''.format(uuid,first_time,last_time)
    _df = pd.read_sql(Sql, con=con_app_fraud)
    return _df

def last_apply_time(userid,apply_time):
    Sql = '''select *  from apply_quota_record 
where user_id ='{0}' and apply_time < '{1}'  ORDER BY apply_time desc limit 1'''.format(userid,apply_time)
    _df = pd.read_sql(Sql, con=con_tuomin_xyqb)
    return _df


def quantity_ofopen_orders(userid,apply_time):
    """存在未结清订单数量（还款中，在贷）"""
    Sql = '''select count(*)  as count from loan_application_manifest_history a
left join repayment_plan b on a.loan_application_history_id=b.loan_application_history_id
and a.contract_term=b.term_no 
where (b.repayment_status not in (3,4) or (b.repayment_status=3 and b.repaid_at>'{0}'))
and a.transaction_status in (2,5) and a.loan_paid_at<'{0}'
and a.user_id='{1}' ;'''.format(apply_time,userid,)
    _df = pd.read_sql(Sql, con=con_tuomin_xyqb)
    return _df


def application_forms_nums(uuid,apply_time):
    """填写中申请单数量"""
    Sql = """select count(*) as count from apply_list
             where apply_status=1 and uuid='{0}' and enable=1 and created_at< '{1}';""".format(uuid,apply_time)
    _df = pd.read_sql(Sql, con=con_business_flow)
    return _df


def requisition_quantity_xyqb(userid,apply_time):
    """xyqb 在在途申请单数量"""
    Sql = """SELECT count(*) as count_xyqb  FROM assign_funding_record a
        left join assets_order b on a.asset_order_id=b.id
        left join waiting_funding_corp_operate_people c on b.loan_id=c.loan_application_history_id
        WHERE a.assign_status=3 and (c.id is null or c.funding_corp_progress not in (5,6))
        and a.user_id='{0}' and a.created_at<'{1}';""".format(userid,apply_time)
    _df = pd.read_sql(Sql, con=con_tuomin_xyqb)
    return _df

def requisition_quantity_business_flow(uuid,apply_time):
    """business_flow 在在途申请单数量"""
    Sql = """SELECT count(*) as count_business FROM apply_list WHERE (apply_status in (2,3) or (apply_status =4 and audit_result<>0))
              and uuid ='{0}' and created_at< '{1}';""".format(uuid,apply_time)
    _df = pd.read_sql(Sql, con=con_business_flow)
    return _df


def user_order_approval(uuid,apply_time):
    Sql = """select count(id) count from apply_list where enable = 1 
        and apply_status =3 and  uuid ='{0}' and created_at< '{1}'; """.format(uuid,apply_time)
    _df = pd.read_sql(Sql, con=con_business_flow)
    return _df

def requisition_quantity_xyqb_new(userid,apply_time):
    """xyqb 在在途申请单数量"""
    Sql = """SELECT count(*) count_xyqb FROM assign_funding_record a
    left join assets_order b on a.asset_order_id=b.id
    left join waiting_funding_corp_operate_people c on b.loan_id=c.loan_application_history_id
    WHERE a.assign_status=3 and (c.id is null or c.funding_corp_progress not in (5,6))
    and a.user_id='{0}' and a.created_at<'{1}';""".format(userid,apply_time)
    _df = pd.read_sql(Sql, con=con_tuomin_xyqb)
    return _df

def requisition_quantity_business_flow_new(uuid,apply_time):
    """business_flow 在在途申请单数量"""
    Sql = """SELECT count(*) count_business FROM apply_list
    WHERE (apply_status in (2,3) or (apply_status =4 and audit_result<>0)) and (assets_result<>2 or assets_result is null)
    and uuid ='{0}' and enable=1 and created_at< '{1}';""".format(uuid,apply_time)
    _df = pd.read_sql(Sql, con=con_business_flow)
    return _df





def get_phone_info(phone_num):
    """根据手机号查询省份"""
    phone_info = Phone().find(phone_num)
    try:
        phone = phone_info['phone']
        province = phone_info['province']  # 省
        city = phone_info['city']  # 城市
        zip_code = phone_info['zip_code']  # 邮编
        area_code = phone_info['area_code']  # 区号
        phone_type = phone_info['phone_type']  # 运营商
    except:
        print('----- the phone number is empty, please check your phone number! -----')
    return phone, province, city, zip_code, area_code, phone_type

# print(get_phone_info('18631179951'))

def city_dict_df():
    """标准的归属地码表"""
    city_dict = {'北京': 11,
                 '天津': 12,
                 '河北': 13,
                 '山西': 14,
                 '内蒙': 15,
                 '辽宁': 21,
                 '吉林': 22,
                 '黑龙江': 23,
                 '上海': 31,
                 '江苏': 32,
                 '浙江': 33,
                 '安徽': 34,
                 '福建': 35,
                 '江西': 36,
                 '山东': 37,
                 '河南': 41,
                 '湖北': 42,
                 '湖南': 43,
                 '广东': 44,
                 '广西': 45,
                 '海南': 46,
                 '重庆': 50,
                 '四川': 51,
                 '贵州': 52,
                 '云南': 53,
                 '西藏': 54,
                 '陕西': 61,
                 '甘肃': 62,
                 '青海': 63,
                 '宁夏': 64,
                 '新疆': 65,
                 '台湾': 71,
                 '香港': 81,
                 '澳门': 82,
                 '海外': 91}
    df = pd.DataFrame(city_dict, pd.Index(range(1)))
    return df

def idcard_dict_df():
    """标准的身份证归属地码表"""
    idcard_dict = {'北京': 11,
                 '天津': 12,
                 '河北': 13,
                 '山西': 14,
                 '内蒙': 15,
                 '辽宁': 21,
                 '吉林': 22,
                 '黑龙江': 23,
                 '上海': 31,
                 '江苏': 32,
                 '浙江': 33,
                 '安徽': 34,
                 '福建': 35,
                 '江西': 36,
                 '山东': 37,
                 '河南': 41,
                 '湖北': 42,
                 '湖南': 43,
                 '广东': 44,
                 '广西': 45,
                 '海南': 46,
                 '重庆': 50,
                 '四川': 51,
                 '贵州': 52,
                 '云南': 53,
                 '西藏': 54,
                 '陕西': 61,
                 '甘肃': 62,
                 '青海': 63,
                 '宁夏': 64,
                 '新疆': 65,
                 '台湾': 71,
                 '香港': 81,
                 '澳门': 82,
                 '海外': 91}

    df = pd.DataFrame(idcard_dict, pd.Index(range(1)))
    return df
