from config.csv_adapter import *
from config.mysql_adapter import *
import pandas
import time
unicom_call_info['sqsj'] = unicom_call_info.modifyDate.apply(
        lambda x: time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(x / 1000)))
unicom_call_info['hour'] = pd.to_datetime(unicom_call_info.cTime).dt.hour
sqsj_dict = dict(zip(unicom_call_info.uuid, unicom_call_info.sqsj))

# 凌晨1-6点通话时长比例
def cell_micallR16_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub[(sub.hour >= 1) & (sub.hour <= 6)].tradeTime.sum() / float(sub.tradeTime.sum())
    result[uuid] = value
    return result


# 凌晨1-6点通话时长
def cell_micallLong_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub[(sub.hour >= 1) & (sub.hour <= 6)].tradeTime.sum()
    result[uuid] = value


# 主叫比例
def cell_zhujiaoRatio_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub[sub.callType == '主叫'].shape[0] / float(sub.shape[0])
    result[uuid] = value


# 近一月主叫比例
def cell_zhujiaoRatio_1mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-06-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    if sub.shape[0] != 0:
        value = sub[sub.callType == '主叫'].shape[0] / float(sub.shape[0])
    else:
        value = ''
    result[uuid] = value
    return result


# 近三月主叫比例
def cell_zhujiaoRatio_3mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-04-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    if sub.shape[0] != 0:
        value = sub[sub.callType == '主叫'].shape[0] / float(sub.shape[0])
    else:
        value = ''
    result[uuid] = value
    return result


# 月均通话次数
def cell_meanMonCallno_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-06-01 00:00:00')]
    value = sub.shape[0] / 4.0
    result[uuid] = value
    return result


# 月均通话时长
def cell_meanMonCallLong_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.tradeTime.sum() / 5.0
    result[uuid] = value
    return result


# 通话对象中手机号的比例
def cell_relateCellRatio_v2(df, uuid):
    result = dict()
    sub = df.loc[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
                 (df.cTime < '2018-07-01 00:00:00')]

    sub['phone_len'] = sub.receiverPhone.apply(lambda x: len(str(int(x))))
    sub['phone_2'] = sub.receiverPhone.astype(str).apply(lambda x: x[:2])
    sub_quchong = sub.drop_duplicates("receiverPhone")

    if len(sub_quchong) >0:
        value = sub_quchong[(sub_quchong.phone_2.isin(['13', '14', '15', '17', '18', '19'])) &
                            (sub_quchong.phone_len == 11)].shape[0] / float(sub_quchong.shape[0])
    else:
        value = None

    result[uuid] = value
    return result


# 近六月出话费账单月份数
def tel_cntMonth_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.billDay.isin(["Thu Feb 01 00:00:00 CST 2018",
                                                   "Thu Mar 01 00:00:00 CST 2018",
                                                   "Sun Apr 01 00:00:00 CST 2018",
                                                   "Tue May 01 00:00:00 CST 2018",
                                                   "Fri Jun 01 00:00:00 CST 2018"]))]
    value = sub.shape[0]
    result[uuid] = value
    return result


# 月均话费消费金额
def tel_meanCPay_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.billDay.isin(["Thu Feb 01 00:00:00 CST 2018",
                                                   "Thu Mar 01 00:00:00 CST 2018",
                                                   "Sun Apr 01 00:00:00 CST 2018",
                                                   "Tue May 01 00:00:00 CST 2018",
                                                   "Fri Jun 01 00:00:00 CST 2018"]))]
    value = sub.groupby("billDay")["amount"].sum()


    if value.shape[0] != 0:
        result[uuid] = value.sum() / float(value.shape[0])
    else:
        result[uuid] = None
    return result


# 单月话费金额最小值
def tel_minCPay_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.billDay.isin(["Thu Feb 01 00:00:00 CST 2018",
                                                   "Thu Mar 01 00:00:00 CST 2018", "Sun Apr 01 00:00:00 CST 2018",
                                                   "Tue May 01 00:00:00 CST 2018",
                                                   "Fri Jun 01 00:00:00 CST 2018"]))]
    value = sub.groupby("billDay")["amount"].min()
    if value.shape[0] != 0:
        result[uuid] = value.min()
    else:
        result[uuid] = None
    return result


# 月均流量使用量
def flow_meanFlow_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.startTime >= '2018-02-01 00:00:00') & (df.startTime < '2018-07-01 00:00:00')]
    sub['month'] = pd.to_datetime(sub.startTime).dt.month
    value = sub.groupby("month")["allFlow"].sum()
    if value.shape[0] != 0:
        result[uuid] = value.mean()
    else:
        result[uuid] = ''
    return result


# 总通话次数
def cell_callno_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    result[uuid] = sub.shape[0]
    return result


# 近一月通话次数
def cell_callno_1mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-06-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    result[uuid] = sub.shape[0]
    return result


# 近三月通话次数
def cell_callno_3mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-04-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    result[uuid] = sub.shape[0]
    return result


# 本地通话比例
def cell_localcallRatio_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    uuid, sub.shape, sub[sub.tradeType == '本地通话'].shape[0], sub[sub.tradeType == u'本地通话'].shape[0]
    if sub.shape[0] > 0:
        value = sub[sub.tradeType == '本地通话'].shape[0] / float(sub.shape[0])
    else:
        value = ''
    result[uuid] = value
    return result


# 近一月通话时长
def cell_callLong_1mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-06-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.tradeTime.sum()
    result[uuid] = value
    return result


# 近三月通话时长
def cell_callLong_3mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-04-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.tradeTime.sum()
    result[uuid] = value
    return result


# 通话联系人个数
def cell_cntRelate_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.receiverPhone.nunique()
    result[uuid] = value
    return result


# 近一月通话联系人个数
def cell_cnRelate_1mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-06-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.receiverPhone.nunique()
    result[uuid] = value
    return result


# 近三月通话联系人个数
def cell_cnRelate_3mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-04-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.receiverPhone.nunique()
    result[uuid] = value
    return result


# 近一月通话联系人个数
def cell_cellRatio_1mon_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-04-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.receiverPhone.nunique()
    result[uuid] = value
    return result


# 最后通话时间
def last_contact_time_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-04-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.cTime.max()
    result[uuid] = value
    return result


# 手机号归属地数量
def mobileLocationNum_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    value = sub.tradeAddr.nunique()
    result[uuid] = value
    return result


# 通话详单中通话时间跨度60天以上的手机号码占比
def callRecordIntervalMore60DaysRate_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    n_phone = sub.receiverPhone.nunique()
    count = 0
    for phone in sub.receiverPhone.unique():
        sub_phone_max = pd.to_datetime(sub[sub.receiverPhone == phone].cTime.max())
        sub_phone_min = pd.to_datetime(sub[sub.receiverPhone == phone].cTime.min())
        delta = (sub_phone_max - sub_phone_min).days
        if delta >= 60:
            count += 1

    try:
        value = count / float(n_phone)
    except Exception as e:
        value = None


    # value = count / float(n_phone)
    result[uuid] = value
    return result


# 通话记录日期跨度
def callRecordInterval_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    if len(sub)>0:
        value = (pd.to_datetime(sub.cTime.max()) - pd.to_datetime(sub.cTime.min())).days
    else:
        value = None
    result[uuid] = value
    return result


# 第一联系人主叫次数
def fst_zj_num_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']

    if len(rank[rank['rank'] == 0]['count'].values)>0:
        result[uuid] = rank[rank['rank'] == 0]['count'].values[0]
    else:
        result[uuid] = 0.00
    return result


# 第一联系人通话次数
def fst_contact_num_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']
    if len(rank[rank['rank'] == 0]['count'].values) >0:
        result[uuid] = rank[rank['rank'] == 0]['count'].values[0]
    else:
        result[uuid] = 0.00
    return result


# 第二联系人通话次数
def sec_contact_num_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']
    if len(rank[rank['rank'] == 1]['count'])>0:
        result[uuid] = rank[rank['rank'] == 1]['count'].values[0]
    else:
        result[uuid] = 0.00
    return result


# 第十联系人通话次数
def tenth_contact_num_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']
    if len(rank[rank['rank'] == 9]['count'].values) > 0 :
        result[uuid] = rank[rank['rank'] == 9]['count'].values[0]
    else:
        result[uuid] = 0.00

    return result


# 前三联系人最长通话时间间隔
def max_contact_itv_3_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']
    max_delta = 0
    for phone in rank.index[:3]:
        sub_phone_max = pd.to_datetime(sub[sub.receiverPhone == phone].cTime.max())
        sub_phone_min = pd.to_datetime(sub[sub.receiverPhone == phone].cTime.min())
        delta = (sub_phone_max - sub_phone_min).days
        if delta > max_delta:
            max_delta = delta
    result[uuid] = max_delta
    return result


# 前10联系人最段通话时间间隔
def min_contact_itv_10_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    if len(sub)>0:
        rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
        rank['rank'] = range(rank.shape[0])
        rank.columns = ['count', 'rank']
        min_delta = 10000
        for phone in rank.index[:10]:
            sub_phone_max = pd.to_datetime(sub[sub.receiverPhone == phone].cTime.max())
            sub_phone_min = pd.to_datetime(sub[sub.receiverPhone == phone].cTime.min())
            delta = (sub_phone_max - sub_phone_min).days
            if delta < min_delta:
                min_delta = delta
    else:
        min_delta = 0.00
    result[uuid] = min_delta
    return result


# 通话详单中通话次数最多的5个手机号在量化派申请人数
def top5PhoneApplyNum_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']
    if len(rank.index)>0:
        top_5_phone_no = str(tuple(rank.index[:5]))
        dt = get_xyqbuser(top_5_phone_no)
        value = dt.shape[0]
        result[uuid] = value
    else:
        result[uuid] = None
    return result


# 通话次数前10位联系人中用户个数
def cont_nuser_rank10_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']
    if len(rank.index)>0:
        top_10_phone_no = str(tuple(rank.index[:10]))
        dt = get_xyqbuser(top_10_phone_no)
        value = dt.shape[0]

        result[uuid] = value
    else:
        result[uuid] = None
    return result


# 主叫的用户数
def cont_nuser_zj_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    zj = sub[sub.callType == '主叫'].receiverPhone
    if len(zj) >0:
        zj_phone_no = str(tuple(zj))
        dt = get_xyqbuser(zj_phone_no)
        value = dt.shape[0]
        result[uuid] = value
    else:result[uuid] = None
    return result


# 通话3次以上的用户数
def cont_nuser_cnt3_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').uuid.count().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['count', 'rank']
    cnt3 = rank[rank['count'] >= 3].index
    top_10_phone_no = str(tuple(cnt3))
    if len(cnt3) == 1:
        top_10_phone_no = top_10_phone_no.replace(',', '')
    dt = get_xyqbuser(top_10_phone_no)
    value = dt.shape[0]

    result[uuid] = value
    return result


# 通话时长大于3分钟的用户数
def cont_nuser_cnt3_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]

    rank = pd.DataFrame(sub.groupby('receiverPhone').tradeTime.sum().sort_values(ascending=False))
    rank['rank'] = range(rank.shape[0])
    rank.columns = ['sum_tradeTime', 'rank']
    cnt3 = rank[rank['sum_tradeTime'] >= 180].index
    if len(cnt3)>0:
        top_10_phone_no = str(tuple(cnt3))
        if len(cnt3) == 1:
            top_10_phone_no = top_10_phone_no.replace(',', '')
        dt = get_xyqbuser(top_10_phone_no)
        value = dt.shape[0]
        result[uuid] = value
    else:result[uuid] = None

    return result


# 近30天联系过的用户数
def cont_nuser_day30_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-06-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    th_phone_no = tuple(sub.receiverPhone.unique())
    if len(th_phone_no) != 0:
        dt = get_xyqbuser(str(th_phone_no))
        value = dt.shape[0]
    else:
        value = None

    result[uuid] = value
    return result


# 与用户联系人联系间隔天数最大值
def cont_day_max_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    th_phone_no = tuple(sub.receiverPhone.unique())
    if len(th_phone_no) != 0:
        dt = get_xyqbuser(str(th_phone_no))
        max_v = 0
        if dt.shape[0] != 0:

            for phone_no in dt.loginName.unique():
                cha = (pd.to_datetime(sub[sub.receiverPhone == phone_no].cTime.max()) - pd.to_datetime(
                        sub[sub.receiverPhone == phone_no].cTime.min())).days
                if cha > max_v:
                    max_v = cha
    else:
        max_v = None

    result[uuid] = max_v
    return result


# 与用户联系人联系时长最大值
def cont_dur_max_v2(df, uuid):
    result = dict()
    sub = df[(df.uuid == uuid) & (df.cTime >= '2018-02-01 00:00:00') &
             (df.cTime < '2018-07-01 00:00:00')]
    th_phone_no = tuple(sub.receiverPhone.unique())
    if len(sub.receiverPhone.unique()) != 0:
        dt = get_xyqbuser(str(th_phone_no))
        max_v = 0
        if dt.shape[0] != 0:

            for phone_no in dt.loginName.unique():
                v = sub[sub.receiverPhone == phone_no].tradeTime.max()
                if v > max_v:
                    max_v = v

    else:
        max_v = 0.00

    result[uuid] = max_v
    return result

    #
def last_apply_loan_success(df,uuid):
    '''上一笔申请是否放款成功'''
    result = dict()
    sub = df.loc[(df['uuid'] == uuid) & (df['last_apply_loan_success'] == 0) ,'last_apply_loan_success'] = 0
    if len(sub) >0:
        return sub
    return result
#
def last_loan_amount(df, uuid):

    df_new = df.loc[(df['uuid'] == uuid) & (df['order_no'] == order_id)]
    df_new['last_loan_amount'] = df_new['last_loan_amount'].fillna(0)
    print(df_new['last_loan_amount'].values[0])
#
#
def last_loan_overdue_days(df, uuid):
    df_new = df.loc[(df['uuid'] == uuid) & (df['order_no'] == order_id)]
    df_new['last_loan_overdue_days'] = df_new['last_loan_overdue_days'].fillna()

    print(df_new['last_loan_overdue_days'].values)


