# -*- coding:utf-8 -*-

from functools import reduce
from datetime import datetime
from collections import defaultdict
from service.Sql_server import *

def f_complexOrder(user_id,columns):

    _result = defaultdict(dict)
    df = get_sql_user_in_loan(user_id)
    for key,values in columns.items():
        _result[key]['name'] = values
    if df.empty:
        for key,value in columns.items():
            _result[key]['value'] = -9999999
        _result["current_loan_order_nums"]['value'] = 0
    else:

        df.sort_values('loan_id',inplace = True)

        # 当前在贷订单数
        current_loan_order_nums = len(df.loc[df.duplicated('loan_id',keep='first')== False])
        _result["current_loan_order_nums"]['value'] = current_loan_order_nums


        # 当前在贷总期数
        current_loan_term_nums = df.loc[df['is_zaidai'] == 1]['is_zaidai'].count()
        #df.groupby('user_id')[['is_zaidai']].agg(lambda x : reduce(lambda x,y: x+y,x)).reset_index()['is_zaidai'].values[0]
        _result["current_loan_term_nums"]['value'] = int(current_loan_term_nums)

        # 当前在贷最大期数
        current_loan_max_term = df.groupby('loan_id')[['is_zaidai']].agg(lambda x: reduce(lambda x,y: x+y,x)).reset_index()['is_zaidai'].max()
        _result["current_loan_max_term"]['value'] = int(current_loan_max_term)


        # 在贷期数占比:未到期的已放款订单中，分子是在贷期数个数之和  分母是在贷订单总期数
        x,y = str(float(current_loan_term_nums/current_loan_max_term)).split('.')
        current_loan_term_rate = float(x+'.'+y[:6])
        _result["current_loan_term_rate"]['value'] = current_loan_term_rate

        # 在贷订单的最大的逾期天数 : 已放款未到期订单中，最大的逾期天数，包括已还和未还
        current_loan_max_duedays = df['passdue_day'].max()
        _result["current_loan_max_duedays"]['value'] = int(current_loan_max_duedays)

        # 在贷订单的最大的逾期本金 : 已放款未到期订单中，最大的逾期本金，包括已还和未还
        if df.loc[(df['passdue_day'] > 0)].empty:
            current_loan_max_duepp = 0
        else:
            current_loan_max_duepp = df.loc[(df['passdue_day'] > 0)]['principal'].max(axis=0)
        _result["current_loan_max_duepp"]['value'] = float(current_loan_max_duepp)

        # 在贷平均每期还款金额 : 未到期的已放款的订单中,分子是 在贷期数的应还总额，分母是 在贷期数个数
        x,y = str(float(df.loc[df['repayment_status']!=3]['required_repayment'].sum()/df.loc[df['repayment_status']!=3]['term_no'].count())).split('.')
        current_loan_avg_repay = float(x+'.'+y[:6])
        _result["current_loan_avg_repay"]['value'] = current_loan_avg_repay

        # 在贷最大的应还金额 : 未到期的已放款订单中，每一期在贷期数的对应的应还金额中，取最大值
        current_loan_max_repay = df.loc[df['repayment_status']!=3]['required_repayment'].max()
        _result["current_loan_max_repay"]['value'] = float(current_loan_max_repay)

        # 在贷最小的应还金额 : 未到期的已放款订单中，每一期在贷期数的对应的应还金额中，取最小值
        current_loan_min_repay = df.loc[df['repayment_status']!=3]['required_repayment'].min()
        _result["current_loan_min_repay"]['value'] = float(current_loan_min_repay)

        # 在贷应还总金额 : 未到期的已放款的订单中，剩余应还总金额
        current_loan_sum_repay = df.loc[df['repayment_status']!=3]['required_repayment'].sum()
        _result["current_loan_sum_repay"]['value'] = float(current_loan_sum_repay)

        # 应还金额在贷率 : 在贷订单的剩余期数的应还总额/在贷订单的总的期数的应还总额
        x,y = str(float(df.loc[df['repayment_status']!=3]['required_repayment'].sum()/df['required_repayment'].sum())).split('.')
        current_loan_repay_rate = float(x+'.'+y[:6])
        _result["current_loan_repay_rate"]['value'] = current_loan_repay_rate

        # 在贷平均每期还款本金 : 在贷应还总本金/在贷期数个数
        principal = float(df.loc[df['repayment_status']!=3]['principal'].sum())
        userId_count = float(df.loc[df['repayment_status']!=3]['user_id'].count())
        if principal > 0 and userId_count>0:
            x,y = str(float(principal/userId_count)).split('.')
            current_loan_avg_repaypp = float(x+'.'+y[:6])
        else:
            current_loan_avg_repaypp = 0
        _result["current_loan_avg_repaypp"]['value'] = current_loan_avg_repaypp


        # 在贷最大的应还本金 : 未到期的已放款订单中，每一期在贷期数的对应的应还本金中，取最大值

        current_loan_max_repaypp = df.loc[df['repayment_status']!=3]['principal'].max()
        _result["current_loan_max_repaypp"]['value'] = float(current_loan_max_repaypp)


        # 在贷最小的应还本金 : 未到期的已放款订单中，每一期在贷期数的对应的应还本金中，取最小值
        current_loan_min_repaypp = df.loc[df['repayment_status']!=3]['principal'].min()
        _result["current_loan_min_repaypp"]['value'] = float(current_loan_min_repaypp)

        # 在贷应还总本金 : 未到期的已放款的订单中，剩余应还总本金
        current_loan_sum_repaypp = df.loc[df['repayment_status']!=3]['principal'].sum()
        _result["current_loan_sum_repaypp"]['value'] = float(current_loan_sum_repaypp)


        # 应还本金在贷率 : 在贷订单的剩余期数的应还本金/在贷订单的总的期数的应还本金
        x,y = str(float(df.loc[df['repayment_status']!=3]['principal'].sum()/df['principal'].sum())).split('.')
        current_loan_repaypp_rate = float(x+'.'+y[:6])
        _result["current_loan_repaypp_rate"]['value'] = current_loan_repaypp_rate


        # 最近一次逾期的距今的天数 : 已放款未到期订单中，最近一次逾期的距今的天数
        if df.loc[df['passdue_day'] > 0].empty:
            days_from_lastdue = 0
        else:
            passdue_day_max = datetime.strptime(str(df.loc[df['passdue_day'] > 0]['deadline'].max()).split(' ')[0],"%Y-%m-%d")
            days_from_lastdue = (datetime.now() - passdue_day_max).days
        _result["days_from_lastdue"]['value'] = int(days_from_lastdue)


        # 最近一次的还款距今的天数 :  已放款未到期订单中，最近一次的还款时间
        record_last_day = datetime.strptime(str(df.loc[(df['repayment_status'] ==3 )]['repaid_at'].max()).split(' ')[0],"%Y-%m-%d")
        days_from_lastrepaid =  (datetime.now() - record_last_day).days
        _result["days_from_lastrepaid"]['value'] = int(days_from_lastrepaid)


        # 在贷逾期0天以上的占比 : 已放款未到期的订单中，分子是到期期数的，逾期>0天的期数个数 分母是 到期期数的个数
        if (df.loc[datetime.strftime(datetime.now(),'%Y-%m-%d') > pd.to_datetime(df['deadline'],format='%Y-%m-%d')]['plan_id'].count() > 0)  &( df.loc[df['passdue_day'] > 0 ]['passdue_day'].count() > 0):
            x,y = str(float(df.loc[df['passdue_day'] > 0 ]['passdue_day'].count() / df.loc[datetime.strftime(datetime.now(),'%Y-%m-%d') > pd.to_datetime(df['deadline'],format='%Y-%m-%d')]['plan_id'].count())).split('.')
            current_loan_0duedays_rate = float(x+'.'+y[:6])
        else : current_loan_0duedays_rate = float(0)
        _result["current_loan_0duedays_rate"]['value'] = current_loan_0duedays_rate


        # 在贷逾期5天以上的占比 : 已放款未到期的订单中，分子是到期期数的，逾期>=5天的期数个数 分母是 到期期数的个数
        deadlineDay_cnt = int(df.loc[datetime.strftime(datetime.now(),'%Y-%m-%d') > pd.to_datetime(df['deadline'],format='%Y-%m-%d')]['plan_id'].count())
        passdueDay_cnt = int(df.loc[df['passdue_day'] > 5 ]['passdue_day'].count())
        if deadlineDay_cnt>0 and passdueDay_cnt > 0 :
            x,y = str(float(passdueDay_cnt/deadlineDay_cnt)).split('.')
            current_loan_5duedays_rate = float(x+'.'+y[:6])
        else:
            current_loan_5duedays_rate = 0
        _result["current_loan_5duedays_rate"]['value'] = current_loan_5duedays_rate


        # 在贷订单逾期订单数 : 已放款未到期的订单中，还款发生逾期的订单数

        current_loan_orderdue_nums = len(list(set(df.loc[df['passdue_day'] > 0 ]['loan_id'].tolist())))
        _result["current_loan_orderdue_nums"]['value'] = int(current_loan_orderdue_nums)


        # 在贷订单逾期订单占比 : 分子是 在贷订单中发生逾期的订单数，分母是在贷订单数
        len_loan_passdue_day = len(list(set(df.loc[df['passdue_day']>0]['loan_id'].tolist())))
        len_loan = len(list(set(df['loan_id'].tolist())))
        if len_loan > 0 and len_loan_passdue_day > 0 :
            x,y = str(float(len_loan_passdue_day/len_loan)).split('.')
            current_loan_orderdue_rate = float(x+'.'+y[:6])
        else:
            current_loan_orderdue_rate = 0
        _result["current_loan_orderdue_rate"]['value'] = current_loan_orderdue_rate


        # 在贷申请次数 : 已放款未到期的订单中，距上一次成功放款后，到本次申请的申请次数,不包括本次申请
        df_temp = df.loc[(df['loan_id'] == df['loan_id'].max())
                         &(df.duplicated('loan_id',keep='first') == False)]
        user_id = df_temp['user_id'].values[0]
        loan_created_at = df_temp['loan_created_at'].astype(str).values[0]
        df_apply_quota_record =get_sql_apply_quota_record(user_id,loan_created_at)
        current_loan_apply_cnt = len(df_apply_quota_record)
        # 在贷拒绝次数 : 已放款未到期的订单中，距上一次成功放款后，到本次申请被拒绝的申请次数，不包括本次申请
        if current_loan_apply_cnt > 0 :
            current_loan_refuse_cnt = df_apply_quota_record.loc[df_apply_quota_record['apply_status'] == 2 ].sum()
        else:
            current_loan_refuse_cnt = 0
        # 在贷拒绝率 : 分子是 在贷拒绝次数，分母是在贷申请次数
        if current_loan_apply_cnt > 0 & current_loan_refuse_cnt > 0 :
            current_loan_refuse_rate = current_loan_apply_cnt/current_loan_refuse_cnt
        else:
            current_loan_refuse_rate = 0
        # print( current_loan_apply_cnt,current_loan_refuse_cnt,current_loan_refuse_rate)

        _result["current_loan_apply_cnt"]['value'] = int(current_loan_apply_cnt)
        _result["current_loan_refuse_cnt"]['value'] = int(current_loan_refuse_cnt)
        _result["current_loan_refuse_rate"]['value'] = int(current_loan_refuse_rate)

    return dict(_result)