# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service.Sql_contactsOperator import *
import datetime


class __INIT__(BF):
    """紧急联系人运营商特征"""
    def __init__(self):
        BF.created_at = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        if self.orderId :
            _df = getSql_Apply_quota_record(self.user_id,self.orderId)
            if _df.empty == False:
                BF.created_at = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')


        BF.user_phone = getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))['phone_no'].tolist()
        BF._df = getSql_EmergencyContact(self.user_id,BF.created_at)
        BF._df.sort_values('created_at',ascending=False,inplace=True)
        BF._df = BF._df.loc[~(BF._df['phone_no'].isin(BF.user_phone))]
        BF._df = BF._df.iloc[:2]
        BF.contacts_phone = BF._df['phone_no'].tolist() # 获取历史联系人手机号



class relation_in_qgblack_cnt():
    """关系联系人在QG黑名单中的个数 user_emergency_contact_in_black"""

    def feature(self):
        _relation_in_qgblack_cnt = -9999999
        if self._df.empty == False:
            _df_qgblack = getSql_relation_in_qgblack(str(tuple(self.contacts_phone)).replace(',)',')'),self.created_at)
            if _df_qgblack.empty==False:
                _df_qgblack = _df_qgblack.drop_duplicates('phone',keep='first')
                _relation_in_qgblack_cnt = _df_qgblack['phone'].count()
            else:
                _relation_in_qgblack_cnt = 0
        self._result['relation_in_qgblack_cnt']['value'] = _relation_in_qgblack_cnt
        return self._result

class call_with_relation_cnt_150():
    """近150天，90天，30天同联系人的通话记录个数 , user_call_with_emergency_contact#150dCallCnt"""
    def feature(self):
        _call_with_relation_cnt = -9999999
        if self._df.empty == False:
            _call_with_relation_cnt = 0
            df_auth = getSql_authorizationPhone(self.uuid,str(tuple(self.user_phone)).replace(',)',')'))
            if df_auth.empty == False:
                contacts_phone = str(tuple(self.contacts_phone)).replace(',)',')')
                df_telephone = get_CallPhone(df_auth,
                                             self.uuid,
                                             str(tuple(self.user_phone)).replace(',)',')'),
                                             contacts_phone,
                                             datetime.timedelta(days=150),self.created_at)
                if df_telephone.empty == False:
                    _call_with_relation_cnt = df_telephone['receiverPhone'].count()

        self._result['call_with_relation_cnt_150']['value'] = _call_with_relation_cnt
        return self._result

class call_with_relation_cnt_90():
    """近150天，90天，30天同联系人的通话记录个数 , user_call_with_emergency_contact#90dCallCnt"""
    def feature(self):
        _call_with_relation_cnt = -9999999
        if self._df.empty == False:
            _call_with_relation_cnt = 0
            df_auth = getSql_authorizationPhone(self.uuid,str(tuple(self.user_phone)).replace(',)',')'))
            if df_auth.empty == False:
                contacts_phone = str(tuple(self.contacts_phone)).replace(',)',')')
                df_telephone = get_CallPhone(df_auth,self.uuid,
                                             str(tuple(self.user_phone)).replace(',)',')') ,
                                             contacts_phone,
                                             datetime.timedelta(days=90),self.created_at)

                if df_telephone.empty == False:
                    _call_with_relation_cnt = df_telephone['receiverPhone'].count()

        self._result['call_with_relation_cnt_90']['value'] = _call_with_relation_cnt
        return self._result

class call_with_relation_cnt_30():
    """近150天，90天，30天同联系人的通话记录个数 , user_call_with_emergency_contact#30dCallCnt"""
    def feature(self):
        _call_with_relation_cnt = -9999999
        if self._df.empty == False:
            _call_with_relation_cnt = 0
            df_auth = getSql_authorizationPhone(self.uuid,str(tuple(self.user_phone)).replace(',)',')'))
            if df_auth.empty == False:
                contacts_phone = str(tuple(self.contacts_phone)).replace(',)',')')
                df_telephone = get_CallPhone(df_auth,self.uuid,
                                             str(tuple(self.user_phone)).replace(',)',')') ,
                                             contacts_phone,
                                             datetime.timedelta(days=30),self.created_at)

                if df_telephone.empty == False:
                    _call_with_relation_cnt = df_telephone['receiverPhone'].count()

        self._result['call_with_relation_cnt_30']['value'] = _call_with_relation_cnt
        return self._result

class call_with_relation_cnt_7():
    """近150天，90天，30天同联系人的通话记录个数 , user_call_with_emergency_contact#7dCallCnt"""
    def feature(self):
        _call_with_relation_cnt = -9999999
        if self._df.empty == False:
            _call_with_relation_cnt = 0
            df_auth = getSql_authorizationPhone(self.uuid,str(tuple(self.user_phone)).replace(',)',')'))
            if df_auth.empty == False:
                contacts_phone = str(tuple(self.contacts_phone)).replace(',)',')')
                df_telephone = get_CallPhone(df_auth,self.uuid,
                                             str(tuple(self.user_phone)).replace(',)',')') ,
                                             contacts_phone,
                                             datetime.timedelta(days=7),self.created_at)

                if df_telephone.empty == False:
                    _call_with_relation_cnt = df_telephone['receiverPhone'].count()

        self._result['call_with_relation_cnt_7']['value'] = _call_with_relation_cnt
        return self._result

class cnt_of_same_relation_repeat_1week():
    """近7天同一关系人手机号被其他申请人也填写的次数之和"""
    def feature(self):
        _cnt_of_same_relation_repeat_1week = -9999999
        if self._df.empty == False:
            nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
            lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=7)),'%Y-%m-%d %H:%M:%S')
            _df = getSql_same_relation_repeat(self.user_id,
                                        str(tuple(self.contacts_phone)).replace(',)',')'),
                                        lastday,nowday
                                        )
            if _df.empty == False:
                _cnt_of_same_relation_repeat_1week = _df.loc[_df.duplicated('user_id',keep='first')==False]['user_id'].count()
            else:
                _cnt_of_same_relation_repeat_1week = 0
        self._result['cnt_of_same_relation_repeat_1week']['value'] = _cnt_of_same_relation_repeat_1week
        return self._result


class numbres_of_relation_applied_7():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG申请次数之和  user_emergency_contact_apply_info#d7"""
    def feature(self):
        _numbres_of_relation_applied =  -9999999
        if self._df.empty == False:

            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _numbres_of_relation_applied = 0
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=7)),'%Y-%m-%d %H:%M:%S')
                _df_userApply = getSql_userApplyQuotaRecord(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'))
                _df_userApply = _df_userApply.loc[(_df_userApply['apply_time']>=str(lastday)) & (_df_userApply['apply_time']<str(nowday))]
                if _df_userApply.empty == False:
                    _numbres_of_relation_applied = _df_userApply['user_id'].count()
        self._result['numbres_of_relation_applied_7']['value'] = _numbres_of_relation_applied
        return self._result

class numbres_of_relation_applied_30():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG申请次数之和  user_emergency_contact_apply_info#d30"""
    def feature(self):
        _numbres_of_relation_applied =  -9999999
        if self._df.empty == False:

            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _numbres_of_relation_applied = 0
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=30)),'%Y-%m-%d %H:%M:%S')
                _df_userApply = getSql_userApplyQuotaRecord(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'))
                _df_userApply = _df_userApply.loc[(_df_userApply['apply_time']>=str(lastday)) & (_df_userApply['apply_time']<str(nowday))]
                if _df_userApply.empty == False:
                    _numbres_of_relation_applied = _df_userApply['user_id'].count()
        self._result['numbres_of_relation_applied_30']['value'] = _numbres_of_relation_applied
        return self._result

class numbres_of_relation_applied_60():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG申请次数之和  user_emergency_contact_apply_info#d60"""
    def feature(self):
        _numbres_of_relation_applied =  -9999999
        if self._df.empty == False:

            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _numbres_of_relation_applied = 0
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=60)),'%Y-%m-%d %H:%M:%S')
                _df_userApply = getSql_userApplyQuotaRecord(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'))
                _df_userApply = _df_userApply.loc[(_df_userApply['apply_time']>=str(lastday)) & (_df_userApply['apply_time']<str(nowday))]
                if _df_userApply.empty == False:
                    _numbres_of_relation_applied = _df_userApply['user_id'].count()
        self._result['numbres_of_relation_applied_60']['value'] = _numbres_of_relation_applied
        return self._result

class numbres_of_relation_applied_90():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG申请次数之和  user_emergency_contact_apply_info#d90"""
    def feature(self):
        _numbres_of_relation_applied =  -9999999
        if self._df.empty == False:

            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _numbres_of_relation_applied = 0
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=90)),'%Y-%m-%d %H:%M:%S')
                _df_userApply = getSql_userApplyQuotaRecord(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'))
                _df_userApply = _df_userApply.loc[(_df_userApply['apply_time']>=str(lastday)) & (_df_userApply['apply_time']<str(nowday))]
                if _df_userApply.empty == False:
                    _numbres_of_relation_applied = _df_userApply['user_id'].count()
        self._result['numbres_of_relation_applied_90']['value'] = _numbres_of_relation_applied
        return self._result

class numbres_of_relation_applied_150():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG申请次数之和  user_emergency_contact_apply_info#d150"""
    def feature(self):
        _numbres_of_relation_applied =  -9999999
        if self._df.empty == False:

            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _numbres_of_relation_applied = 0
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                _df_userApply = getSql_userApplyQuotaRecord(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'))
                _df_userApply = _df_userApply.loc[(_df_userApply['apply_time']>=str(lastday)) & (_df_userApply['apply_time']<str(nowday))]
                if _df_userApply.empty == False:
                    _numbres_of_relation_applied = _df_userApply['user_id'].count()
        self._result['numbres_of_relation_applied_150']['value'] = _numbres_of_relation_applied
        return self._result

class numbres_of_relation_applied_all():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG申请次数之和  user_emergency_contact_apply_info#all"""
    def feature(self):
        _numbres_of_relation_applied =  -9999999
        if self._df.empty == False:

            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _numbres_of_relation_applied = 0
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=60)),'%Y-%m-%d %H:%M:%S')
                _df_userApply = getSql_userApplyQuotaRecord(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'))
                _df_userApply = _df_userApply.loc[(_df_userApply['apply_time']<str(nowday))]
                if _df_userApply.empty == False:
                    _numbres_of_relation_applied = _df_userApply['user_id'].count()
        self._result['numbres_of_relation_applied_all']['value'] = _numbres_of_relation_applied
        return self._result

class numbers_of_relation_loan_7():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG贷款次数之和  user_emergency_contact_loan_info#d7"""
    def feature(self):
        _numbers_of_relation_loan =  -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=7)),'%Y-%m-%d %H:%M:%S')
                _df_userLoan = getSql_numbers_of_relation_loan(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'),
                                                               lastday,nowday
                                                               )
                if _df_userLoan.empty == False:
                    _numbers_of_relation_loan = _df_userLoan['loan_id'].count()
                else:
                    _numbers_of_relation_loan = 0
        self._result['numbers_of_relation_loan_7']['value'] = _numbers_of_relation_loan
        return self._result

class numbers_of_relation_loan_30():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG贷款次数之和  user_emergency_contact_loan_info#d150"""
    def feature(self):
        _numbers_of_relation_loan =  -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=30)),'%Y-%m-%d %H:%M:%S')
                _df_userLoan = getSql_numbers_of_relation_loan(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'),
                                                               lastday,nowday
                                                               )
                if _df_userLoan.empty == False:
                    _numbers_of_relation_loan = _df_userLoan['loan_id'].count()
                else:
                    _numbers_of_relation_loan = 0
        self._result['numbers_of_relation_loan_30']['value'] = _numbers_of_relation_loan
        return self._result

class numbers_of_relation_loan_60():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG贷款次数之和  user_emergency_contact_loan_info#d150"""
    def feature(self):
        _numbers_of_relation_loan =  -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=60)),'%Y-%m-%d %H:%M:%S')
                _df_userLoan = getSql_numbers_of_relation_loan(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'),
                                                               lastday,nowday
                                                               )
                if _df_userLoan.empty == False:
                    _numbers_of_relation_loan = _df_userLoan['loan_id'].count()
                else:
                    _numbers_of_relation_loan = 0
        self._result['numbers_of_relation_loan_60']['value'] = _numbers_of_relation_loan
        return self._result

class numbers_of_relation_loan_90():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG贷款次数之和  user_emergency_contact_loan_info#d150"""
    def feature(self):
        _numbers_of_relation_loan =  -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=90)),'%Y-%m-%d %H:%M:%S')
                _df_userLoan = getSql_numbers_of_relation_loan(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'),
                                                               lastday,nowday
                                                               )
                if _df_userLoan.empty == False:
                    _numbers_of_relation_loan = _df_userLoan['loan_id'].count()
                else:
                    _numbers_of_relation_loan = 0
        self._result['numbers_of_relation_loan_90']['value'] = _numbers_of_relation_loan
        return self._result

class numbers_of_relation_loan_150():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG贷款次数之和  user_emergency_contact_loan_info#d150"""
    def feature(self):
        _numbers_of_relation_loan =  -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                _df_userLoan = getSql_numbers_of_relation_loan(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'),
                                                            lastday,nowday
                                                            )
                if _df_userLoan.empty == False:
                    _numbers_of_relation_loan = _df_userLoan['loan_id'].count()
                else:
                    _numbers_of_relation_loan = 0
        self._result['numbers_of_relation_loan_150']['value'] = _numbers_of_relation_loan
        return self._result

class numbers_of_relation_loan_all():
    """近7天，30天，60天，90天，150天 ，及历史 关系人手机号在QG贷款次数之和  user_emergency_contact_loan_info#all"""
    def feature(self):
        _numbers_of_relation_loan =  -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                nowday = datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                # lastday = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d %H:%M:%S')
                _df_userLoan = getSql_numbers_of_relation_loan(str(tuple(set(_df_user['user_id'].tolist()))).replace(',)',')'),
                                                               None,nowday
                                                               )
                if _df_userLoan.empty == False:
                    _numbers_of_relation_loan = _df_userLoan['loan_id'].count()
                else:
                    _numbers_of_relation_loan = 0
        self._result['numbers_of_relation_loan_all']['value'] = _numbers_of_relation_loan
        return self._result

class days_of_on_passdue():
    """关系人在QG的在逾最大逾期天数之和 user_emergency_contact_loan_max_delq_days#uncomplateLoan"""
    def feature(self):
        _days_of_on_passdue = -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(_df_user['user_id'].tolist())).replace(',)',')'))
                # _df_loan = _df_loan.loc[_df_loan['repayment_status'] == 3]
                _df_loan = get_Loan_rollBack(_df_loan,self.created_at)
                if _df_loan.empty == False:
                    _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([15])]
                    if _df_loan_new.empty == False:
                        _days_of_on_passdue = _df_loan_new.groupby('user_id').agg({'passdue_day':'max'}).reset_index()['passdue_day'].sum()

        self._result['days_of_on_passdue']['value'] = _days_of_on_passdue
        return self._result

class days_of_history_passdue():
    """关系人在QG的历史最大逾期天数之和 user_emergency_contact_loan_max_delq_days#loanPost"""
    def feature(self):
        _days_of_history_passdue = -9999999
        if self._df.empty == False:
            _df_user = getSql_phoneForUserId(str(tuple(self.contacts_phone)).replace(',)',')'))
            if _df_user.empty == False:
                _df_loan = getSql_loanAll(str(tuple(_df_user['user_id'].tolist())).replace(',)',')'))
                # _df_loan = _df_loan.loc[_df_loan['repayment_status'] == 3]

                if _df_loan.empty == False:
                    _df_loan['observationTime'] = self.created_at # datetime.datetime.strftime(self.created_at,'%Y-%m-%d %H:%M:%S')
                    _df_loan = _df_loan.loc[_df_loan['apply_time'] < _df_loan['observationTime'] ]
                    if _df_loan.empty == False:
                        _df_loan['repaid_at'] = _df_loan['repaid_at'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['deadline'] = _df_loan['deadline'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['observationTime'] = _df_loan['observationTime'].apply(lambda x : datetime.datetime.strptime(datetime.datetime.strftime(x,'%Y-%m-%d 00:00:00'),'%Y-%m-%d 00:00:00'))
                        _df_loan['passdue_day'] = 0

                        _df_loan.loc[(_df_loan['observationTime'] >_df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0
                        _df_loan.loc[(_df_loan['observationTime'] < _df_loan['deadline']) & (_df_loan['observationTime'] <_df_loan['repaid_at']),'repayment_status'] = 0

                        _df_loan.loc[_df_loan['repayment_status']!=3,'repayment_status'] = 0
                        _df_loan.loc[_df_loan['repayment_status']!=3,'repaid_at'] = datetime.datetime.strptime('2000-01-01 00:00:00','%Y-%m-%d 00:00:00')

                        _df_loan.loc[(_df_loan['repaid_at']!='2000-01-01') ,'passdue_day'] = (_df_loan['repaid_at'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['repaid_at']=='2000-01-01') ,'passdue_day'] = (_df_loan['observationTime'] - _df_loan['deadline']).dt.days
                        _df_loan.loc[(_df_loan['passdue_day'] <= 0),'passdue_day'] = 0

                        _df_loan['passdue_day'] = _df_loan['passdue_day'].fillna(0)
                        _loan_id = _df_loan.loc[(_df_loan['observationTime']<_df_loan['deadline'])&(_df_loan['repayment_status']!=3)]['loan_id'].tolist()
                        _loan_id = list(set(_loan_id))
                        if _loan_id:
                            _df_loan.loc[(_df_loan['loan_id'].isin(_loan_id)),'progress'] = 15
                        _df_loan_new = _df_loan.loc[_df_loan['progress'].isin([16])]
                        if _df_loan_new.empty == False:
                            _days_of_history_passdue = _df_loan_new.groupby('user_id').agg({'passdue_day':'max'}).reset_index()['passdue_day'].sum()

        self._result['days_of_history_passdue']['value'] = _days_of_history_passdue
        return self._result



class diffdays_fst_call_with_relation():
    """近150天同联系人的最早通话距离现在的天数 user_call_with_emergency_contact#diffFstCallDays"""
    def feature(self):
        _diffdays_fst_call_with_relation = -9999999
        if self._df.empty == False:
            df_auth = getSql_authorizationPhone(self.uuid,str(tuple(self.user_phone)).replace(',)',')'))
            if df_auth.empty == False:
                df_auth['modifyDate'] = df_auth['modifyDate'].astype(str)
                # auth_time = datetime.datetime.strptime(df_auth['modifyDate'].max(),'%Y-%m-%d %H:%M:%S')
                # auth_time_last = auth_time - datetime.timedelta(days=150)
                # auth_time = datetime.datetime.strftime(self.created_at,'%Y-%m-%d 00:00:00')
                # auth_time_last = datetime.datetime.strftime((self.created_at -datetime.timedelta(days=150)),'%Y-%m-%d 00:00:00')


                # df_mobile = getSql_mobileCallInfoDataService(uuid = self.uuid,user_phone = str(tuple(self.user_phone)).replace(',)',')'), contacts_phone=contacts_phone,time_start = str(auth_time_last),time_end = str(auth_time))
                # df_telecom = getSql_telecomCallInfoDataService(uuid = self.uuid,user_phone = str(tuple(self.user_phone)).replace(',)',')'), contacts_phone=contacts_phone,time_start = str(auth_time_last),time_end = str(auth_time))
                # df_unicom = getSql_unicomCallInfoDataService(uuid = self.uuid,user_phone = str(tuple(self.user_phone)).replace(',)',')'), contacts_phone=contacts_phone,time_start = str(auth_time_last),time_end = str(auth_time))
                # df_telephone = pd.concat([df_mobile,df_telecom,df_unicom])

                contacts_phone = str(tuple(self.contacts_phone)).replace(',)',')')
                df_telephone = get_CallPhone(df_auth,self.uuid,str(tuple(self.user_phone)).replace(',)',')'),contacts_phone,datetime.timedelta(days=150),self.created_at)
                if df_telephone.empty == False:
                    _diffdays_fst_call_with_relation = (datetime.datetime.strptime(str(self.created_at).split(' ')[0],'%Y-%m-%d') - datetime.datetime.strptime(str(pd.to_datetime(df_telephone['cTime']).min()).split(' ')[0],'%Y-%m-%d')  ).days
        self._result['diffdays_fst_call_with_relation']['value'] = _diffdays_fst_call_with_relation
        return self._result

class diffdays_last_call_with_relation():
    """近150天同联系人的最新通话距离现在的天数 user_call_with_emergency_contact#diffLastCallDays"""
    def feature(self):
        _diffdays_last_call_with_relation = -9999999
        if self._df.empty == False:
            df_auth = getSql_authorizationPhone(self.uuid,str(tuple(self.user_phone)).replace(',)',')'))
            df_auth['modifyDate'] = df_auth['modifyDate'].astype(str)
            if df_auth.empty == False:

                contacts_phone = str(tuple(self.contacts_phone)).replace(',)',')')
                df_telephone = get_CallPhone(df_auth,self.uuid,str(tuple(self.user_phone)).replace(',)',')'),contacts_phone,datetime.timedelta(days=150),self.created_at)
                if df_telephone.empty == False:
                    # _diffdays_last_call_with_relation = (self.created_at - pd.to_datetime(df_telephone['cTime']).max()).days
                    _diffdays_last_call_with_relation = (datetime.datetime.strptime(str(self.created_at).split(' ')[0],'%Y-%m-%d') - datetime.datetime.strptime(str(pd.to_datetime(df_telephone['cTime']).max()).split(' ')[0],'%Y-%m-%d')  ).days
        self._result['diffdays_last_call_with_relation']['value'] = _diffdays_last_call_with_relation
        return self._result

class diffdays_call_with_relation():
    """近150天同联系人的最新通话距离天数 -  近150天同联系人的最早通话距离天数  user_call_with_emergency_contact#diffCallWithRelationDays"""
    def feature(self):
        _diffdays_call_with_relation = -9999999
        if self._df.empty == False:
            df_auth = getSql_authorizationPhone(self.uuid,str(tuple(self.user_phone)).replace(',)',')'))
            df_auth['modifyDate'] = df_auth['modifyDate'].astype(str)
            if df_auth.empty == False:

                contacts_phone = str(tuple(self.contacts_phone)).replace(',)',')')
                df_telephone = get_CallPhone(df_auth,self.uuid,
                                             str(tuple(self.user_phone)).replace(',)',')') ,
                                             contacts_phone,
                                             datetime.timedelta(days=150),self.created_at)

                if df_telephone.empty == False:
                    diffdays_call_with_relation_min = (datetime.datetime.strptime(str(self.created_at).split(' ')[0],'%Y-%m-%d') - datetime.datetime.strptime(str(pd.to_datetime(df_telephone['cTime']).min()).split(' ')[0],'%Y-%m-%d')  ).days

                    diffdays_call_with_relation_max = (datetime.datetime.strptime(str(self.created_at).split(' ')[0],'%Y-%m-%d') - datetime.datetime.strptime(str(pd.to_datetime(df_telephone['cTime']).max()).split(' ')[0],'%Y-%m-%d')  ).days
                    _diffdays_call_with_relation = diffdays_call_with_relation_min - diffdays_call_with_relation_max
        self._result['diffdays_call_with_relation']['value'] = _diffdays_call_with_relation
        return self._result