# -*- coding:utf-8 -*-

from features.Base_Features import BaseFeatures as BF
from service import Sql_contactsOperator
from service.Sql_contactsEmergency import *
import datetime

# 紧急联系人特征
class __INIT__(BF):
    def __init__(self):
        BF._apply_time = datetime.datetime.strptime(datetime.datetime.strftime(datetime.datetime.now(),'%Y-%m-%d %H:%M:%S'),'%Y-%m-%d %H:%M:%S')
        _df = pd.DataFrame()
        if self.orderId :
            _df = Sql_contactsOperator.getSql_Apply_quota_record(self.user_id,self.orderId)
            BF._apply_time = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        else:
            _df = Sql_contactsOperator.getSql_Apply_quota_record(self.user_id)

        # if _df.empty == False:
        #     BF._apply_time = datetime.datetime.strptime(_df['apply_time'].astype(str).values[0],'%Y-%m-%d %H:%M:%S')
        BF._df_userPhone = Sql_contactsOperator.getSql_userPhone(str(tuple([self.user_id])).replace(',)',')'))
        BF.userPhone = BF._df_userPhone['phone_no'].values[0]

        df_userContactAll = getSql_userContactAll(self.user_id,BF._apply_time)
        df_userContactAll = df_userContactAll.loc[df_userContactAll['contact_phone_no']!= BF.userPhone]
        df_userContactAll = df_userContactAll.groupby(['contact_phone_no']).agg({'phone_no':'first','user_id':'first','created_at':'max'}).reset_index()
        df_userContactAll.sort_values('created_at',ascending=False,inplace=True)

        df_userContactAll = df_userContactAll.iloc[:2]
        BF.userContactPhone = None
        if df_userContactAll.empty == False:
            BF.userContactPhone = str(tuple(list(set(df_userContactAll['contact_phone_no'])))).replace(',)',')')

        BF._df_userIsContact = ''
        BF._df_contactIsUser = ''
        BF._df_userContactis_OtherUserContactis = ''
        BF._df_loan = ''
        pass

def get_userApplyisContact(df_userIsContact,df_userPhone,apply_time,user_phone):
    """获取用户手机号被其他用户填写为联系人的用户"""
    if isinstance(df_userIsContact,str):
        df_userIsContact = getSql_userApplyisContact(str(tuple(df_userPhone['phone_no'])).replace(',)',')'),apply_time)
        df_userIsContact = df_userIsContact.loc[df_userIsContact['phone_no'] != user_phone]
        df_userIsContact.sort_values('created_at',ascending=False,inplace=True)
        # df_userIsContact = df_userIsContact.iloc[:1]
    return df_userIsContact

def get_userApplyisContactisApply(df_contactIsUser,user_id,user_phone,apply_time,contact_phone):
    if isinstance(df_contactIsUser,str):
        df_contactIsUser = pd.DataFrame()
        if contact_phone != None:
            df_contactIsUser = getSql_ContactGetUser(contact_phone,apply_time)
            # df_contactIsUser = getSql_EmergencyContact(user_id,apply_time,contact_phone)
            df_contactIsUser.loc[(df_contactIsUser['user_id'].isna()),'user_id'] = -1
            df_contactIsUser = df_contactIsUser.loc[~(df_contactIsUser['user_id'] == -1)]
            df_contactIsUser['user_id']= df_contactIsUser['user_id'].astype(int)
            df_contactIsUser = df_contactIsUser.loc[df_contactIsUser['phone_no'] != user_phone]

    return df_contactIsUser

def get_userContactis_OtherUserContactis(df_userContactis_OtherUserContactis,user_id,user_phone,apply_time,contact_phone):
    """用户联系人是其他用户的联系人（不包括当前用户)"""
    if isinstance(df_userContactis_OtherUserContactis,str):
        df_userContactis_OtherUserContactis = pd.DataFrame()
        if contact_phone != None:
            df_userContactis_OtherUserContactis = getSql_userContactis_OtherUserContactis(user_id,apply_time,contact_phone)
            # df_userContactis_OtherUserContactis.loc[df_userContactis_OtherUserContactis['contact_phone_no'] != user_phone]
            df_userContactis_OtherUserContactis.sort_values('current_contact_created_at',ascending=False, inplace=True)
            # df_userContactis_OtherUserContactis = df_userContactis_OtherUserContactis.iloc[:2]
    return df_userContactis_OtherUserContactis

def get_LoanDatail_And_RollBack(df_loan,user_id,apply_time):
    """获取用户订单明细,回滚订单数据"""
    df_loan = ''
    if isinstance(df_loan,str):
        df_loan = Sql_contactsOperator.getSql_loanAll(str(tuple(user_id)).replace(',)',')'))
        df_loan = Sql_contactsOperator.get_Loan_rollBack(df_loan,apply_time)
    return df_loan

class applyisrelation_orders_of_passdue_in_history():
    """
        user_phone_is_other_user_e_c_loan_delq_info#loanPostGt0DLoanCount
        applyisrelation_orders_of_passdue_in_history
    	现在的申请人是之前的联系人，对应的发生逾期的订单数是多少(历史)
    """
    def feature(self):
        _applyisrelation_orders_of_passdue_in_history = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time, self.userPhone)
        _df_userIsContact = self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_id = list(set(_df_userIsContact['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                if _df_loan.empty == False:
                    passdue_order_no = len(list(set(_df_loan.loc[_df_loan['passdue_day']>0]['loan_id'])))
                    _applyisrelation_orders_of_passdue_in_history =  passdue_order_no

        self._result['applyisrelation_orders_of_passdue_in_history']['value'] = _applyisrelation_orders_of_passdue_in_history
        return self._result

class applyisrelation_in_qgblack():
    """
    user_phone_is_other_user_e_c_in_black
    applyisrelation_in_qgblack
    现在的申请人是之前的联系人，对应的命中黑名单个数
    """
    def feature(self):
        _applyisrelation_in_qgblack = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time,self.userPhone)
        _df_userIsContact = self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_phone = _df_userIsContact['phone_no'].tolist()
            _df_qgblack = Sql_contactsOperator.getSql_relation_in_qgblack(str(tuple(user_phone)).replace(',)',')'),self._apply_time)

            _applyisrelation_in_qgblack = len(list(set(_df_qgblack['phone'].tolist())))
        self._result['applyisrelation_in_qgblack']['value'] = _applyisrelation_in_qgblack
        return self._result


class applyisrelation_orders_of_over90days_passdue():
    """
    user_phone_is_other_user_e_c_loan_delq_info#uncomplateLoanGt90DLoanCount
    applyisrelation_orders_of_over90days_passdue
    现在的申请人是之前的联系人，对应的逾期超过90天的订单数（在逾）"""
    def feature(self):
        _applyisrelation_orders_of_over90days_passdue = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time,self.userPhone)
        _df_userIsContact =  self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_id = list(set(_df_userIsContact['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    _df_loan = _df_loan.loc[_df_loan['passdue_day']>90]
                    passdue_order_no = len(list(set(_df_loan['loan_id'])))
                    _applyisrelation_orders_of_over90days_passdue =  passdue_order_no

        self._result['applyisrelation_orders_of_over90days_passdue']['value'] = _applyisrelation_orders_of_over90days_passdue
        return self._result

class applyisrelation_orders_of_over15days_passdue():
    """
    user_phone_is_other_user_e_c_loan_delq_info#uncomplateLoanGt15DLoanCount
    applyisrelation_orders_of_over15days_passdue
    现在的申请人是之前的联系人，对应的逾期超过15天的订单数（在逾）
    """
    def feature(self):
        _applyisrelation_orders_of_over15days_passdue = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time,self.userPhone)
        _df_userIsContact =  self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_id = list(set(_df_userIsContact['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    _df_loan = _df_loan.loc[_df_loan['passdue_day']>15]
                    passdue_order_no = len(list(set(_df_loan['loan_id'])))
                    _applyisrelation_orders_of_over15days_passdue =  passdue_order_no

        self._result['applyisrelation_orders_of_over15days_passdue']['value'] = _applyisrelation_orders_of_over15days_passdue
        return self._result

class applyisrelation_orders_of_over30days_refuse():
    """user_phone_is_other_user_e_c_apply_refuse_count#30d
    applyisrelation_orders_of_over30days_refuse
    现在的申请人是之前的联系人，对应的近30天内申请被拒的订单个数"""
    def feature(self):
        _applyisrelation_orders_of_over30days_refuse = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time,self.userPhone)
        _df_userIsContact =  self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_id =list(set(_df_userIsContact['user_id'].tolist()))
            _df_userApply = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple(user_id)).replace(',)',')'))
            time_from = self._apply_time - datetime.timedelta(days=30)
            time_now = self._apply_time
            _df_userApply = _df_userApply.loc[(_df_userApply['apply_time'] > time_from) & (_df_userApply['apply_time'] < time_now)]
            if _df_userApply.empty == False:
                _applyisrelation_orders_of_over30days_refuse = _df_userApply.loc[_df_userApply['apply_status'] == 1]['user_id'].count()
        self._result['applyisrelation_orders_of_over30days_refuse']['value'] = _applyisrelation_orders_of_over30days_refuse
        return self._result

class applyisrelation_totaldays_on_passdue():
    """
        user_phone_is_other_user_e_c_loan_delq_info#uncomplateLoanTotalOverdueDays
    	applyisrelation_totaldays_on_passdue
    	现在的申请人是之前的联系人，对应的在逾天数之和（在逾）
    """
    def feature(self):
        _applyisrelation_totaldays_on_passdue = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time,self.userPhone)
        _df_userIsContact =  self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_id = list(set(_df_userIsContact['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    _df_loan_g = _df_loan.groupby('loan_id').agg({'passdue_day':'max'}).reset_index()
                    _applyisrelation_totaldays_on_passdue =  _df_loan_g['passdue_day'].sum()

        self._result['applyisrelation_totaldays_on_passdue']['value'] = _applyisrelation_totaldays_on_passdue
        return self._result

class applyisrelation_orders_on_passdue():
    """
        user_phone_is_other_user_e_c_loan_delq_info#uncomplateLoanGt0DLoanCount
        applyisrelation_orders_on_passdue
        现在的申请人是之前的联系人，对应的在逾订单数（在逾）
    """
    def feature(self):
        _applyisrelation_orders_on_passdue = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time,self.userPhone)
        _df_userIsContact =  self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_id = list(set(_df_userIsContact['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    _df_loan = _df_loan.loc[_df_loan['passdue_day']>0]
                    _applyisrelation_orders_on_passdue =  len(list(set(_df_loan['loan_id'])))

        self._result['applyisrelation_orders_on_passdue']['value'] = _applyisrelation_orders_on_passdue
        return self._result

class applyisrelation_totaldays_of_passdue_in_history():
    """
        user_phone_is_other_user_e_c_loan_delq_info#loanPostTotalOverdueDays
        applyisrelation_totaldays_of_passdue_in_history
        现在的申请人是之前的联系人，对应的历史逾期天数之和（历史）
    """
    def feature(self):
        _applyisrelation_totaldays_of_passdue_in_history = -9999999
        self._df_userIsContact = get_userApplyisContact(self._df_userIsContact,self._df_userPhone,self._apply_time,self.userPhone)
        _df_userIsContact =  self._df_userIsContact
        if _df_userIsContact.empty == False:
            user_id = list(set(_df_userIsContact['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:

                _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                if _df_loan.empty == False:
                    _df_loan_g = _df_loan.groupby('loan_id').agg({'passdue_day':'max'}).reset_index()
                    _applyisrelation_totaldays_of_passdue_in_history =  _df_loan_g['passdue_day'].sum()

        self._result['applyisrelation_totaldays_of_passdue_in_history']['value'] = _applyisrelation_totaldays_of_passdue_in_history
        return self._result

class relationisapply_orders_of_passdue_in_history():
    """
        user_emergency_contact_loan_delq_info#loanPostGt0DLoanCount
        relationisapply_orders_of_passdue_in_history
        现在的联系人是之前的申请人，对应的发生逾期的订单数是多少(历史)
    """

    def feature(self):
        _relationisapply_orders_of_passdue_in_history = -9999999
        self._df_contactIsUser = get_userApplyisContactisApply(self._df_contactIsUser,self.user_id,self.userPhone,self._apply_time,self.userContactPhone)

        _df_contactIsUser = self._df_contactIsUser
        if _df_contactIsUser.empty == False:
            user_id = _df_contactIsUser['user_id'].tolist()
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                if _df_loan.empty == False:
                    _df_loan = _df_loan.loc[_df_loan['passdue_day'] > 0]
                    passdue_loanId =len(set(_df_loan['loan_id']))
                    _relationisapply_orders_of_passdue_in_history = passdue_loanId

        self._result['relationisapply_orders_of_passdue_in_history']['value'] = _relationisapply_orders_of_passdue_in_history
        return self._result

class relationisapply_orders_of_over90days_passdue():
    """
    user_emergency_contact_loan_delq_info#uncomplateLoanGt90DLoanCount
    relationisapply_orders_of_over90days_passdue
    现在的联系人是之前的申请人，对应的逾期超过90天的订单数
    """
    def feature(self):
        _relationisapply_orders_of_over90days_passdue = -9999999
        self._df_contactIsUser = get_userApplyisContactisApply(self._df_contactIsUser,self.user_id,self.userPhone,self._apply_time,self.userContactPhone)
        _df_contactIsUser = self._df_contactIsUser
        if _df_contactIsUser.empty == False:
            user_id = _df_contactIsUser['user_id'].tolist()
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:

                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    passdue_order_no = len(list(set(_df_loan.loc[_df_loan['passdue_day']>90]['loan_id'])))
                    _relationisapply_orders_of_over90days_passdue =  passdue_order_no

        self._result['relationisapply_orders_of_over90days_passdue']['value'] = _relationisapply_orders_of_over90days_passdue
        return self._result

class relationisapply_orders_of_over15days_passdue():
    """
    user_emergency_contact_loan_delq_info#uncomplateLoanGt15DLoanCount
    relationisapply_orders_of_over15days_passdue
    现在的联系人是之前的申请人，对应的逾期超过15天的订单数(在逾)
    """
    def feature(self):
        _relationisapply_orders_of_over15days_passdue = -9999999

        self._df_contactIsUser = get_userApplyisContactisApply(self._df_contactIsUser,self.user_id,self.userPhone,self._apply_time,self.userContactPhone)
        _df_contactIsUser = self._df_contactIsUser
        if _df_contactIsUser.empty == False:
            user_id = _df_contactIsUser['user_id'].tolist()
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    passdue_order_no = len(list(set(_df_loan.loc[_df_loan['passdue_day']>15]['loan_id'])))
                    _relationisapply_orders_of_over15days_passdue = passdue_order_no

        self._result['relationisapply_orders_of_over15days_passdue']['value'] = _relationisapply_orders_of_over15days_passdue
        return self._result

class relationisapply_orders_of_over30days_refuse():
    """
        user_emergency_contact_apply_refuse_count#30d
        relationisapply_orders_of_over30days_refuse
        现在的联系人是之前的申请人，对应的近30天内申请被拒的订单个数
    """
    def feature(self):
        _relationisapply_orders_of_over30days_refuse = -9999999
        self._df_contactIsUser = get_userApplyisContactisApply(self._df_contactIsUser,self.user_id,self.userPhone,self._apply_time,self.userContactPhone)
        _df_contactIsUser = self._df_contactIsUser
        if _df_contactIsUser.empty == False:
            user_id =_df_contactIsUser['user_id'].tolist()
            _df_userApply = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple(user_id)).replace(',)',')'))
            time_from = self._apply_time - datetime.timedelta(days=30)
            time_now = self._apply_time
            _df_userApply = _df_userApply.loc[(_df_userApply['apply_time'] > time_from) & (_df_userApply['apply_time'] < time_now)]
            if _df_userApply.empty == False:
                _relationisapply_orders_of_over30days_refuse =_df_userApply.loc[(_df_userApply['apply_status'] == 1)]['user_id'].count()
        self._result['relationisapply_orders_of_over30days_refuse']['value'] = _relationisapply_orders_of_over30days_refuse
        return self._result

class relationisapply_orders_on_passdue():
    """
    user_emergency_contact_loan_delq_info#uncomplateLoanGt0DLoanCount
    relationisapply_orders_on_passdue
    现在的联系人是之前的申请人，对应的在逾订单数(在逾)
    """
    def feature(self):
        _relationisapply_orders_on_passdue = -9999999

        self._df_contactIsUser = get_userApplyisContactisApply(self._df_contactIsUser,self.user_id,self.userPhone,self._apply_time,self.userContactPhone)
        _df_contactIsUser = self._df_contactIsUser
        if _df_contactIsUser.empty == False:
            user_id = list(set(_df_contactIsUser['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:

                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    _df_loan = _df_loan.loc[_df_loan['passdue_day']>0]
                    passdue_order_no = len(set(_df_loan['loan_id']))
                    _relationisapply_orders_on_passdue =  passdue_order_no

        self._result['relationisapply_orders_on_passdue']['value'] = _relationisapply_orders_on_passdue
        return self._result

class relationisapply_totaldays_of_passdue_in_history():
    """
    user_emergency_contact_loan_delq_info#loanPostTotalOverdueDays
    relationisapply_totaldays_of_passdue_in_history
    现在的联系人是之前的申请人，对应的历史逾期天数之和
    """
    def feature(self):
        _relationisapply_totaldays_of_passdue_in_history = -9999999
        self._df_contactIsUser = get_userApplyisContactisApply(self._df_contactIsUser,self.user_id,self.userPhone,self._apply_time,self.userContactPhone)
        _df_contactIsUser = self._df_contactIsUser
        if _df_contactIsUser.empty == False:
            user_id = list(set(_df_contactIsUser['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                if _df_loan.empty == False:
                    _df_loan_g = _df_loan.groupby('loan_id').agg({'passdue_day':'max'}).reset_index()
                    passdue_sum = _df_loan_g['passdue_day'].sum()
                    _relationisapply_totaldays_of_passdue_in_history = passdue_sum
        self._result['relationisapply_totaldays_of_passdue_in_history']['value'] = _relationisapply_totaldays_of_passdue_in_history
        return self._result


class commonrelation_orders_of_passdue_in_history():
    """
    user_same_e_c_user_loan_delq_info#loanPostGt0DLoanCount
    commonrelation_orders_of_passdue_in_history
    现在的联系人是另一个申请人的联系人，对应的发生逾期的订单数是多少(历史)
    """
    def feature(self):
        _commonrelation_orders_of_passdue_in_history = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:
            user_id = list(set(df_userContactis_OtherUserContactis['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:

                _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                if _df_loan.empty == False:
                    _df_loan = _df_loan.loc[_df_loan['passdue_day'] > 0]
                    passdue_sum = _df_loan.drop_duplicates('loan_id', keep='first')['loan_id'].count()
                    _commonrelation_orders_of_passdue_in_history = passdue_sum
        self._result['commonrelation_orders_of_passdue_in_history']['value'] = _commonrelation_orders_of_passdue_in_history
        return self._result

class commonrelation_in_qgblack():
    """
        user_same_e_c_user_in_black
        commonrelation_in_qgblack
        现在的联系人是另一个申请人的联系人，对应的命中黑名单个数
    """
    def feature(self):
        _commonrelation_in_qgblack = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:
            user_phone = df_userContactis_OtherUserContactis['phone_no'].tolist()
            _df_qgblack = Sql_contactsOperator.getSql_relation_in_qgblack(str(tuple(user_phone)).replace(',)',')'),self._apply_time)
            _commonrelation_in_qgblack = len(list(set(_df_qgblack['phone'].tolist())))
        self._result['commonrelation_in_qgblack']['value'] = _commonrelation_in_qgblack
        return self._result
class commonrelation_orders_of_over90days_passdue():
    """
        user_same_e_c_user_loan_delq_info#uncomplateLoanGt90DLoanCount
        commonrelation_orders_of_over90days_passdue
        现在的联系人是另一个申请人的联系人，对应的逾期超过90天的订单数(在逾)
    """
    def feature(self):
        _commonrelation_orders_of_over90days_passdue = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:
            user_id = list(set(df_userContactis_OtherUserContactis['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:

                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    passdue_order_no = len(list(set(_df_loan.loc[_df_loan['passdue_day']>90]['loan_id'])))
                    _commonrelation_orders_of_over90days_passdue =  passdue_order_no
        self._result['commonrelation_orders_of_over90days_passdue']['value'] = _commonrelation_orders_of_over90days_passdue
        return self._result

class commonrelation_orders_of_over15days_passdue():
    """
        user_same_e_c_user_loan_delq_info#uncomplateLoanGt15DLoanCount
        commonrelation_orders_of_over15days_passdue
        现在的联系人是另一个申请人的联系人，对应的逾期超过15天的订单数(在逾)
    """
    def feature(self):
        _commonrelation_orders_of_over15days_passdue = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:
            user_id = list(set(df_userContactis_OtherUserContactis['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:

                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    passdue_order_no = len(list(set(_df_loan.loc[_df_loan['passdue_day']>15]['loan_id'])))
                    _commonrelation_orders_of_over15days_passdue =  passdue_order_no
        self._result['commonrelation_orders_of_over15days_passdue']['value'] = _commonrelation_orders_of_over15days_passdue
        return self._result

class commonrelation_orders_of_over30days_refuse():
    """
        user_same_e_c_user_apply_refuse_count#30d
        commonrelation_orders_of_over30days_refuse
        现在的联系人是另一个申请人的联系人，对应的近30天内申请被拒的订单个数
    """
    def feature(self):
        _commonrelation_orders_of_over30days_refuse = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:

            user_id =df_userContactis_OtherUserContactis['user_id'].tolist()
            _df_userApply = Sql_contactsOperator.getSql_userApplyQuotaRecord(str(tuple(user_id)).replace(',)',')'))
            time_from = self._apply_time - datetime.timedelta(days=30)
            time_now = self._apply_time
            _df_userApply = _df_userApply.loc[(_df_userApply['apply_time'] > time_from) & (_df_userApply['apply_time'] < time_now)]
            if _df_userApply.empty == False:
                _commonrelation_orders_of_over30days_refuse = _df_userApply.loc[_df_userApply['apply_status'] == 1]['user_id'].count()
        self._result['commonrelation_orders_of_over30days_refuse']['value'] = _commonrelation_orders_of_over30days_refuse
        return self._result

class commonrelation_totaldays_on_passdue():
    """
        user_same_e_c_user_loan_delq_info#uncomplateLoanTotalOverdueDays
        commonrelation_totaldays_on_passdue
        现在的联系人是另一个申请人的联系人，对应的在逾天数之和
    """
    def feature(self):
        _commonrelation_totaldays_on_passdue = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:
            user_id = list(set(df_userContactis_OtherUserContactis['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    _df_loan_g = _df_loan.groupby('loan_id').agg({'passdue_day':'max'}).reset_index()
                    passdue_sum = _df_loan_g['passdue_day'].sum()
                    _commonrelation_totaldays_on_passdue =  passdue_sum
        self._result['commonrelation_totaldays_on_passdue']['value'] = _commonrelation_totaldays_on_passdue
        return self._result

class commonrelation_orders_on_passdue():
    """
        user_same_e_c_user_loan_delq_info#uncomplateLoanGt0DLoanCount
        commonrelation_orders_on_passdue
        现在的联系人是另一个申请人的联系人，对应的在逾订单数
    """
    def feature(self):
        _commonrelation_orders_on_passdue = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:
            user_id = list(set(df_userContactis_OtherUserContactis['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:

                _df_loan = _df_loan.loc[(_df_loan['progress'] == 15)]
                if _df_loan.empty == False:
                    _df_loan = _df_loan.loc[_df_loan['passdue_day']>0]
                    _commonrelation_orders_on_passdue =  len(list(set(_df_loan['loan_id'])))
        self._result['commonrelation_orders_on_passdue']['value'] = _commonrelation_orders_on_passdue
        return self._result


class commonrelation_totaldays_of_passdue_in_history():
    """
        user_same_e_c_user_loan_delq_info#loanPostTotalOverdueDays
        commonrelation_totaldays_of_passdue_in_history
        现在的联系人是另一个申请人的联系人，对应的历史逾期天数之和
    """
    def feature(self):
        _commonrelation_totaldays_of_passdue_in_history = -9999999
        self._df_userContactis_OtherUserContactis = get_userContactis_OtherUserContactis(self._df_userContactis_OtherUserContactis,self.user_id,self.userPhone ,self._apply_time,self.userContactPhone)
        df_userContactis_OtherUserContactis = self._df_userContactis_OtherUserContactis
        if df_userContactis_OtherUserContactis.empty == False:
            user_id = list(set(df_userContactis_OtherUserContactis['user_id'].tolist()))
            self._df_loan = get_LoanDatail_And_RollBack(self._df_loan,user_id,self._apply_time)
            _df_loan = self._df_loan
            if _df_loan.empty == False:
                _df_loan = _df_loan.loc[(_df_loan['progress'] == 16)]
                if _df_loan.empty == False:
                    _df_loan_g = _df_loan.groupby('loan_id').agg({'passdue_day':'max'}).reset_index()
                    _commonrelation_totaldays_of_passdue_in_history = _df_loan_g['passdue_day'].sum()
        self._result['commonrelation_totaldays_of_passdue_in_history']['value'] = _commonrelation_totaldays_of_passdue_in_history
        return self._result