# -*- coding:utf-8 -*-

import importlib
import pandas as pd
from service.Mapping import Mapping
from collections import defaultdict
import re
from itertools import chain
import datetime

class BaseFeatures():
    @classmethod
    def get_subclasses(cls,featureName,mapping):
        ''' 类反射 '''

        cls._result = defaultdict(dict)
        codes = list(set(','.join(cls.codes).split(','))) # 对codes 进行去重
        if '' in codes:
            codes.remove('')
        path = featureName.split('.')  # 获取文件路径
        result = cls.get_mappingTosubclasses(path,codes,mapping,cls._result)

        # def get_attr(imt_py,package,code,result):
        #     """ 递归引入特征库,返回输出结果 """
        #     try :
        #         obj_class = getattr(imt_py,code)
        #         obj_class.feature(cls)
        #         result[code].update({'msg':''})
        #     except:
        #         result[code].update({'value':None,'msg':'检查返回值是否存在'})
        # #
        # for i in result:
        #     _class = list(result[i].keys())[0]
        #     cls._result[_class] = result[i][_class]
        #     if cls._result[_class]['value'] == None and 'msg' not in list(cls._result[_class].keys()):
        #         if result[i][_class]['featrueEL'] == '':
        #             try:
        #                 m_py = importlib.import_module(cls._result[_class]['package_filename'])
        #                 getattr(m_py,"__INIT__")()
        #
        #                 get_attr(m_py,result[i][_class]['package_filename'],result[i][_class]['class'],cls._result)
        #             except:
        #                 cls._result.update({str(result[i]['package_filename']):{'value':None,'msg':'这个文件 %s 存在错误,请检查文件路径和这个文件的初始化类是否存在' % result[i]['特征平台特征字段名称']}})

        def get_attr(cls,imt_py,package,dcode,result):
            """ 递归引入特征库,返回输出结果 """
            try :
                # print(dcode['class'],dcode['package_filename'])
                feature_logc = dcode['class'].split('_and_')
                class_name = feature_logc[0]
                day_window = None
                if len(feature_logc)>1:
                    day_window = feature_logc[1]

                obj_class = getattr(imt_py,class_name)
                # obj_class = getattr(imt_py,dcode['class'])
                if day_window:
                    obj_class.feature(cls,dcode['class'],feature_logc[1:])
                else:
                    obj_class.feature(cls)
                result[dcode['class']].update({'msg':''})
            except:
                result[dcode['class']].update({'value':None,'msg':'检查返回值是否存在'})
        _keys = []
        _values = []
        for k,v in result.items():
            _keys.extend(v.keys())
            _v = list(v.values())[0]
            _v['sort'] = k
            _values.append(_v)
            cls._result.update({_v['class']:_v})
        df = pd.DataFrame(_values)
        df['filename'] = df['package_filename'].apply(lambda x : x.split('.')[2])
        df = df.loc[df['featrueEL'] == 400]

        df_g = df.groupby(['filename'])

        for package ,v in df_g:
            df = pd.DataFrame(v)
            package_filename = v['package_filename'].values[0]
            df.sort_values(['sort'],ascending=True,inplace=True)
            try:
                m_py = importlib.import_module(package_filename)
                getattr(m_py,"__INIT__")()
                df.apply(lambda x : get_attr(cls,m_py,package_filename,x,cls._result),axis=1)
            except:
                cls._result.update({package:{'value':None,'msg':'这个文件 %s 存在错误,请检查文件路径和这个文件的初始化类是否存在'%(package)}})

        diff_codes = list(set(codes).difference(set(mapping['特征平台特征字段名称'].tolist())))
        if diff_codes:
            for code in diff_codes:
                if code != '':
                    cls._result.update({code:{'codes':codes,'class':codes,'value':None,'msg':'code 值不存在'}})
        # except:
        #     return cls._result.update({'错误信息: ','检查文件路径: {0}  和codes {1}'.format(path[0],path[1])})
        cls._result = Mapping._set_Mapping_rename(mapping,cls._result,codes)
        # Mapping._set_Mapping_rename(df_subclasses,cls._result,codes)
        cls._result = dict(cls._result)
        return cls._result

    @classmethod
    def get_featureEL(cls,codes_new,codes,mapping):
        """获取特征中的EL 表达式,同时对特征进行重组
            :return codes_new 一个完整的需要计算的codes
            dummy_feature#degree_one_m5_call_top1_cnt_ratio	近150天1度联系人中通话次数top1的通话次数占比
            degree_one_call_contact#call_top3_cnt_per_number	近150天1度联系人中通话次数top3的号均通话次数
        """
        if codes:
            if codes_new.count(codes)==0:
                codes_new.append(codes)
            df_featrueEL = mapping.loc[(mapping['需求字段名'].isin(codes))
                                       & ((mapping['特征组合']!=400) & ~(mapping['特征组合'].isin(list(set(chain(*codes_new))))))
                                    ]
            # df_featrueEL = mapping.loc[(mapping['需求字段名'].isin(codes))
            #                            & ~(mapping['特征组合'].isin(list(set(chain(*codes_new)))))
            #                         ]

            if df_featrueEL.empty == False:

                df_featrueEL['featrueElName'] = None
                df_featrueEL['featrueElName'] = df_featrueEL['特征组合'].apply(lambda x : cls.get_split(x))
                featureEl = list(set(chain(*df_featrueEL['featrueElName'])))
                if featureEl not in codes_new:
                    codes_new.append(featureEl)
                    cls.get_featureEL(codes_new,codes_new[len(codes_new)-1],mapping)
        return codes_new

    @classmethod
    def get_mappingTosubclasses(cls,featureName,codes,mapping,result):
        """将传入的特征名称转为代码存储的类名"""
        codes = mapping.loc[mapping['特征平台特征字段名称'].isin(codes)]['需求字段名'].tolist()
        if codes:
            codes_new = cls.get_featureEL([],codes,mapping)
            if len(codes_new)<=0:
                codes_new = [codes]
            _result = defaultdict(list)
            index = 0
            temp_code = []
            for i in range(len(codes_new)-1,-1,-1):
                for code in codes_new[i]:
                    _c = mapping.loc[mapping['需求字段名'] == code]
                    if _c.empty == False:
                        _c =_c.to_dict(orient='records')[0]
                        _c['value'] = None
                        if _c['需求字段名'] not in temp_code:
                            _result[index] = {_c['需求字段名']:{'class':_c['需求字段名'],'codes':_c['特征平台特征字段名称'],
                                                          'package_filename':_c['package_filename'],'value':None,
                                                          'desc':_c['字段含义'],'featrueEL':_c['特征组合'],'featrueELL':_c['特征组合_list']}}
                            temp_code.extend([_result[index][_c['需求字段名']]['class']])
                            index += 1
            return _result
        else:
            return result


    def set_business_type(self,_business_type):
        self.business_type = _business_type

    def set_user_uuid(self,_uuid):
        self.uuid = _uuid

    def set_user_id(self,_user_id):
        self.user_id = _user_id

    def set_loan_id(self,_loanId):
        self.loanId = _loanId

    def set_term_no(self,_termNo):
        self.termNo = _termNo

    def set_apply_time(self,_apply_time):
        self.apply_time = _apply_time

    def set_codes(self,_codes):
        self.codes = _codes

    def set_mapping(self,mapping):
        self.mapping = mapping

    @classmethod
    def set_private_var(cls,**kwargs):
        """动态生成变量并赋值"""
        for key ,value in kwargs.items():
            setattr(cls,key,value)


    @classmethod
    def get_split(cls,text):
        # pattern = r',|\.|/|;|\'|`|\[|\]|<|>|\?|:|"|\{|\}|\~|!|@|#|\$|%|\^|&|\(|\)|-|=|\_|\+|，|。|、|；|‘|’|【|】|·|！| |…|（|）'
        pattern = r',|\.|/|;|\'|`|\[|\]|<|>|\?|:|"|\{|\}|\~|!|@|\$|%|\^|&|\(|\)|-|=|\+|，|。|、|；|‘|’|【|】|·|！|…|（|）'
        if text:
            result_list = re.split(pattern, text)
            for i in range(len(result_list)):
                result_list[i] = str(result_list[i].strip())
            return result_list
        else:return None

    @classmethod
    def get_DayWindow(cls,apply_at,days_num):
        """
            时间窗口
            :apply_at : 窗口的起始时间
            :days_num : 窗口天数
        """
        day_window = datetime.datetime.strftime(apply_at - datetime.timedelta(days=int(days_num)), '%Y-%m-%d %H:%M:%S')
        return day_window

