# -*- coding:utf-8 -*-

'''
json 组装
'''
import json


## 常数变量定义
## json 返回中的 错误码定义
class Constants:
    Code_Success = 200
    Msg_Success = 'SUCCESS'

    Code_Error = 400
    Msg_Error = '程序有错'

    Code_user_Success = 200
    Msg_user_Success = '用户注册成功'

    Code_user_Not = 200
    Msg_user_Not = '用户已存在'

    Code_visit_Error = 500
    Msg_visit_Error ='拒绝访问'

    Code_params_Error = 500
    Msg_params_Error ='参数错误'




def build_json_feature(features=None,code=None,mssage=None,**kwargs):

    if features == None:
        features = []
    body = {}

    for key,value in kwargs.items():
        body[str(key)] = value
    try :
        ddata = {'code':code,'mssage':mssage,'data':dict(subInfo = body,features=eval(repr(features)))}
    except Exception as e:
        print(e.args)

    return json.dumps(ddata,ensure_ascii=False)

# businessType=int(_business_type), orderId=_orderId, loanId=_loanId,uuid = _uuid,
# data=_result, flag=True)
#
# def build_json_feature (features=None, code=Constants.Code_Success, msg=Constants.Msg_Success):
#
#     if data == None:
#         data = []
#     ddata = dict(code=code, businessCode=code, msg=msg, features=features)

def build_json_feature_two(data):
    return json.dumps(data,ensure_ascii=False)

"""
只返回 错误码 + 错误提示
"""


def build_json(code, msg):
    ddata = dict(code=code, msg=msg, businessCode=code)
    # return json.dumps(ddata,encoding='UTF-8',ensure_ascii=False) #python2
    return json.dumps(ddata, ensure_ascii=False)  # python3


"""
错误码 默认为 成功；
data may be dict array
"""


def build_json_with_data(data=None, code=Constants.Code_Success, msg=Constants.Msg_Success):
    if data == None:
        data = []
    ddata = dict(code=code, businessCode=code, msg=msg, data=data)
    # return json.dumps(ddata,encoding='UTF-8',ensure_ascii=False) # python2
    return json.dumps(ddata, ensure_ascii=False)  # python3


def build_json_with_data_page(data=None, total=0, page_no=1, page_size=20, code=Constants.Code_Success,
                              msg=Constants.Msg_Success):
    page_no = int(page_no)
    page_size = int(page_size)
    total = int(total)
    if total % page_size == 0:
        _page_total = total / page_size
    else:
        _page_total = total / page_size + 1
    # ==没有查询到数据，则data 为空
    if total == 0:
        data = []
    _data = dict(data=data, page_no=int(page_no), page_size=int(page_size), page_total=int(_page_total),
                 total=int(total))
    ddata = dict(code=code, businessCode=code, msg=msg, data=_data)
    # return json.dumps(ddata,encoding='UTF-8',ensure_ascii=False) # python2
    return json.dumps(ddata, ensure_ascii=False)  # python3


def build_json_with_block(data=None, code=Constants.Code_Success, msg=Constants.Msg_Success):
    ddata = dict(code=code, businessCode=code, msg=msg, data=data)
    # return json.dumps(ddata,encoding='UTF-8',ensure_ascii=False) # python2
    return json.dumps(ddata, ensure_ascii=False)  # python3


"""
转换为 dict 对象; 直接 json.key 获取数据
如果data 为空，返回一个空的data数据
"""


def str_parse_json(data):
    if any(data):
        return json.loads(data, encoding='UTF-8')
    return dict()
