# -*- coding:utf-8 -*-

'''
服务启动接口
'''
from tornado.web import Application
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
import tornado.log
import logging
import tornado.options
import config.settings as URL
from handler import UserRegister_Handler
from tornado.options import define, options

define("port", default=21000, help="run on the given port ", type=int)
define("debug", default=True, help="is debug", type=bool)
define("log_path", default='/tmp', help="log path ", type=str)
options.parse_command_line()

class LogFormatter(tornado.log.LogFormatter):

    def __init__(self):
        super(LogFormatter, self).__init__(
            fmt='%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s',
            datefmt='%Y-%m-%d %H:%M:%S'
        )

def apps():
    return Application([
        (URL.url_userRegister, UserRegister_Handler.UserRegister),
    ])


if __name__ == "__main__":
    if options:
        app = apps()
        server = HTTPServer(app)
        [i.setFormatter(LogFormatter()) for i in logging.getLogger().handlers]
        tornado.options.parse_command_line()

        # #== 本地调试
        app.listen(21000)
        IOLoop.instance().start()

    else:
        app = apps()
        http_server = tornado.httpserver.HTTPServer(app)
        http_server.bind(options.port)
        http_server.start()
        tornado.ioloop.IOLoop.instance().start()
