import re

class Data_Page:
    """
        :param current_page 当前页码
        :param data 要分页的数据
        :param path 路由地址(用于生成动态路径)
        :param per_page 每页显示条数
        :param show_page 显示页码跨度
    """

    def __init__(self, current_page, data, path, per_page=50, show_page=10):
        self.current_page = int(current_page)
        self.per_page = per_page
        self.show_page = show_page
        self.data = data
        self.path = path
        self.all_page = self.get_all_page()

    def get_all_page(self):
        """计算总页数"""
        result, mod = divmod(len(self.data), self.per_page)
        if mod:
            return result + 1
        else:
            return result

    def create_page(self):
        """创建页码列表"""
        if not (isinstance(self.show_page, int) | self.show_page < 1):
            self.show_page = 10

        half = self.show_page // 2

        #  避免出现负数页
        if self.current_page - half <= 0:
            start = 1
        else:
            start = self.current_page - half
        if self.current_page + half > self.all_page:
            end = self.all_page
        else:
            end = self.current_page + half

        # 若当前页靠近两端，保持页面达到show_page的数量
        if self.current_page <= 5  :  #靠近前端
            if self.show_page + 1 <=self.all_page:
                end = self.show_page + 1
            else:
                end = self.all_page

        if self.current_page >= self.all_page - 5:  #靠近最后
            if self.all_page - self.show_page >= 0:
                start = self.all_page - self.show_page
            else:
                start = 1

        # 上下页
        page_list = []
        pre_page = self.current_page - 1 if self.current_page - 1 > 0 else 1
        next_page = self.current_page + 1 if self.current_page + 1 < self.all_page else self.all_page
        # 将生成的页码标签添加进page_list
        page_list.append(self.get_page_url(self.path, '上一页', pre_page))
        for i in range(start, end + 1):
            url = self.get_page_url(self.path, i, i)
            page_list.append(url)
        page_list.append(self.get_page_url(self.path, '下一页', next_page))

        return self.url_format_by_bootstrap(page_list)

    def per_page_content(self, data):
        """计算每页内容"""
        start_index = (self.current_page - 1) * self.per_page
        end_index = self.current_page * self.per_page
        return data[start_index:end_index]

    #  声明为静态方法，未使用类中变量
    @staticmethod
    def get_page_url(path, text, num):
        """获取动态页码链接"""
        url = '<a href="{0}?page={1}">{2}</a>'.format(path, num, text)
        return url

    def url_format_by_bootstrap(self, page_list):
        """将url转化为bootstrap分页需要的格式"""
        pre_url = re.findall('href="(.*?)"', page_list[0])[0]
        next_url = re.findall('href="(.*?)"', page_list[-1])[0]
        page_list[0] = '''
                        <li>
                            <a href="{0}" aria-label="Previous">
                                <span aria-hidden="true">&laquo;</span>
                            </a>
                        </li>
                        '''.format(pre_url)
        page_list[-1] = '''
                       <li>
                           <a href="{0}" aria-label="Next">
                               <span aria-hidden="true">&raquo;</span>
                           </a>
                       </li>
                       '''.format(next_url)
        for index, page in enumerate(page_list[1:-1]):
            # 将当前页设置为选中状态
            # print(page)
            page_num = int(re.search(r'page=(\d+)', page).group(1))

            # page_num=1
            if self.current_page == page_num:
                page_list[index + 1] = '<li class="active">{0}</li>'.format(page)
                continue
            page_list[index + 1] = '<li>{0}</li>'.format(page)

        return page_list
