from collections import defaultdict

import bs4

from service.Base_Service import Base,Result


class QueryInfomation(Base):
    """查询记录"""
    def __init__(self,filepath):
        Base.__init__(self,filepath)
        if '查询记录' in self.menu_dict.keys():
            self.menu_queryInformation = self.get_menuDetail_personalInformation(self.menu_dict['查询记录'])
            Result.set_result(self.get_Logic(self.menu_queryInformation))
        else:
            Result.set_result({'查询记录':None})
        pass

    def get_Logic(self,tag):
        result = {}
        if '查询记录汇总' in tag.keys():
            result.update(self.get_querySummary(tag,'查询记录汇总'))
        if '信贷审批查询记录明细' in tag.keys():
            result.update(self.get_queryCreditApprovalDetail(tag,'信贷审批查询记录明细'))
        return result

    def get_querySummary(self,tag,name):
        """查询记录汇总"""
        _result = {'最近1个月内的查询机构数':{'贷款审批':None,'信用卡审批':None},
                  '最近1个月内的查询次数':{'贷款审批':None,'信用卡审批':None,'本人查询':None},
                  '最近2年内的查询次数':{'贷后管理':None,'担保资格审查':None,'特约商户实名审查':None}
                  }
        result = {name:{}}
        values = []
        tds = self.get_table(tag[name][0])
        for i ,td in enumerate(tds[2]):
            if isinstance(td,bs4.element.Tag):
                tm = ''
                for msg in td.stripped_strings:
                    tm+=msg
                values.append(tm)
        index = 0
        for k ,v in _result.items():
            for kk,vv in v.items():
                result[name][kk+k] = values[index]
                index+=1
        return result

    def get_queryCreditApprovalDetail(self,tag,name):
        """信贷审批查询记录明细"""
        result = {}
        table = tag[name][0].tbody.children
        result.update(self.get_json(table))
        result[name] = result.pop(0)
        return result

    def get_json(self,tag):
        result = defaultdict(list)
        key = []
        _num = 0
        for tr in tag:
            index = 0
            if isinstance(tr,bs4.element.Tag):
                tds = tr.find_all('td')
                value = []
                #         key = []
                td_num = len(tds)
                for td in tds:
                    for m in td.stripped_strings:
                        if td.get('style') == None:
                            key.append(m)
                        else:
                            value.append(m)
                        index+=1

                if len(key)!=td_num:
                    key = key[len(key)-td_num:]
                    _num += 1
                if value:
                    result[_num].append(dict(zip(key,value)))
        return result


if __name__ == '__main__':
    QueryInfomation()