import bs4

from service.Base_Service import Base,Result


class InformationSummary(Base):
    """信息概要"""
    def __init__(self,filepath):
        Base.__init__(self,filepath)

        if '信息概要' in self.menu_dict.keys():
            self.menu_informationSummary = self.get_menuDetail(self.menu_dict['信息概要'])  # 信息概要

            Result.set_result(self.get_Logic(self.menu_informationSummary))
        else:
            Result.set_result({'信息概要':None})
        pass

    def get_Logic(self,tag):
        result = {}
        if '信用提示' in tag.keys(): # 信用汇总
            result.update(self.get_information_creditSummary(tag,'信用提示'))
            result.update(self.get_numberUnscramble(tag,'信用提示'))
        if '逾期及违约信息概要' in tag.keys():
            result.update(self.get_information_overdueAndDefault(tag,'逾期及违约信息概要'))

        if '授信及负债信息概要' in tag.keys(): # 未结清贷款信息汇总 / 未销户贷记卡信息汇总 / 未销户准贷记卡信息汇总
            result.update(self.get_information_uncLoanSummary(tag,'授信及负债信息概要'))

        return result

    def get_information_creditSummary(self,tag,name):
        """信用提示 - 信用汇总or信用提示"""
        result = {'信用汇总':{}}
        tag = self.menu_informationSummary['信用提示'][0]
        table_tag = self.get_table(tag)
        result['信用汇总'].update(self.get_json(table_tag))
        return result

    def get_numberUnscramble(self,tag,name):
        """信用提示 - 个人信用报告 “数字解读”"""
        result = {}
        tag = tag[name]
        istrue = False
        key = ''
        if tag:
            for i,t in enumerate(tag):
                if isinstance(t,bs4.element.Tag):
                    if '个人信用报告 “数字解读”' in t.td.get_text():
                        istrue = True
                        key = t.td.get_text()
                        table = t.next_sibling.next_sibling
        if istrue:
            tag = table
            if tag:
                if tag.find_all('tbody'):
                    for i,t in enumerate(tag):
                        if isinstance(t,bs4.element.Tag):
                            table_tag = self.get_table(t)
                            _json = self.get_json(table_tag)
                            result[key] = _json
        return result

    def get_information_uncLoanSummary(self,tag,name):
        """未结清贷款信息汇总 / 未销户贷记卡信息汇总 / 未销户准贷记卡信息汇总"""
        result = {}
        tag = tag[name]
        if tag:
            for i,t in enumerate(tag):
                if isinstance(t,bs4.element.Tag):
                    if t.td.get('align'):
                        key = t.td.get_text()
                    else:
                        if t.tbody:
                            table_tag = self.get_table(t)
                            _json = self.get_json(table_tag)
                            result[key] = _json
        return result

    def get_information_overdueAndDefault(self,tag,name):
        """逾期及违约信息概要"""
        result = {}
        tags = tag[name]
        if tags:
            for i,tag in enumerate(tags):
                if isinstance(tag,bs4.element.Tag):
                    if tag.td.get('align'):
                        key = tag.td.get_text() # 获取第一行,设置为head
                    else:
                        if tag.tbody:
                            table_tag = self.get_table(tag)
                            _json = self.get_json_overdueAndDefault(table_tag)
                            result[key] = _json
        result['逾期信息汇总'] = result.pop('逾期（透支）信息汇总')
        return result
    def get_json_overdueAndDefault(self,tag):
        """解析table"""
        column = [] #一共几列
        head = []
        key = []
        body = []
        line_id = 0 #行
        row_id = 0 #列
        values = []
        result = {}
        for i,tds in enumerate(tag):
            tds = tds.children
            for ii ,td in enumerate(tds):
                if isinstance(td,bs4.element.Tag):
                    if td.get('colspan'):
                        column.append(int(td.get('colspan')))
                        tm = ''
                        for k in td.stripped_strings:
                            tm+=k
                        head.append(tm)
                    else:
                        tm = ''
                        for k in td.stripped_strings:
                            tm+=k
                        values.append(tm)
                        row_id += 1
                        if line_id<=1:
                            if row_id % column[line_id] == 0:
                                key.append(values)
                                values = []
                            #                         print(row_id,line_id,column[line_id])
                        else:
                            if row_id % column[line_id] == 0:
                                body.append(values)
                                values = []
            line_id +=1
        for i,h in enumerate(head):
            result[h] = dict(zip(key[i],body[i]))
        return result



if __name__ == '__main__':
    InformationSummary()