# -*- coding:utf-8 -*-

'''
服务启动接口
'''
from tornado.web import Application
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
import tornado.log
import logging
import tornado.options
from tornado.options import options, define
define("port", default=20010, help="run on the given port ", type=int)
# define("log_path", default='/tmp', help="log path ", type=str)
define("debug", default=True, help="enable debug mode")
options.parse_command_line()
from config import settings
from handler import ReportAnalysis_Handler,UpLoadFiles_Handler


class LogFormatter(tornado.log.LogFormatter):
    def __init__(self):
        print('%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s')
        super(LogFormatter, self).__init__(
                fmt='%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s',
                datefmt='%Y-%m-%d %H:%M:%S'
        )

def apps():

    return Application([
        (settings.url_reportanalysis, ReportAnalysis_Handler.ReportAnalysis),
        (settings.url_uploadfiles, UpLoadFiles_Handler.UpLoadFiles),

    ],**settings.settings)

if __name__ == "__main__":
    debug = options.debug
    if debug:
        app = apps()
        server = HTTPServer(app)
        [i.setFormatter(LogFormatter()) for i in logging.getLogger().handlers]
        # #== 本地调试
        app.listen(20011)
        IOLoop.instance().start()

    else:
        app = apps()
        http_server = tornado.httpserver.HTTPServer(app)
        http_server.bind(options.port)
        http_server.start()
        tornado.ioloop.IOLoop.instance().start()
