# -*- coding:utf-8 -*-

from utils import JsonUtil
from handler.Base_Handler import BaseHandler
from config import settings

class UpLoadFiles(BaseHandler):
    def post(self):
        # self._filepath = self.get_arguments('filepath', default=None)
        try :
            self._filepath = self.request.files['filepath']
        except :
            self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_Params_Error,
                                           mssage=JsonUtil.Constants.Msg_Params_Error.format('filepath','无参数')))
            self.flush()

        file_name = None
        file_body = None
        if self._filepath:
            for meta in self._filepath:
                file_name = meta['filename']
                file_body = meta['body']

        if file_name:
            if file_body:
                try :

                    with open(settings.HTML_PATH+'/'+file_name,'wb+') as f_to:
                        f_to.write(file_body)
                        f_to.close()
                        self.write(JsonUtil.build_json(code=JsonUtil.Constants.Code_Success,
                                                       mssage=JsonUtil.Constants.Msg_Success,
                                                       report='文件上传成功'
                                                       ))

                    # with open(filepath, 'rb') as f:
                    #     with open(settings.HTML_PATH+'/'+self._filepath.split('/')[-1],'wb+') as f_to:
                    #         f_to.write(f.read())
                    #         f_to.close()
                    #         self.write(JsonUtil.build_json(code=JsonUtil.Constants.Code_Success,
                    #                                        mssage=JsonUtil.Constants.Msg_Success,
                    #                                        report='文件上传成功'
                    #                                        ))
                    #     f.close()
                    self.flush()
                    self.finish()

                except IOError as e:
                    print(e)
                    self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_FileUp_Error,
                                                   mssage = JsonUtil.Constants.Msg_FileUp_Error))
                    self.flush()
            else:
                self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_Params_Error,
                                               mssage=JsonUtil.Constants.Msg_Params_Error.format('文件body无内容',file_body)))
                self.flush()

        else:

            self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_Params_Error,
                                           mssage=JsonUtil.Constants.Msg_Params_Error.format('文件名称不存在',file_name)))
            self.flush()

