# -*- coding:utf-8 -*-

import threading
from utils import JsonUtil
from handler.Base_Handler import BaseHandler
from service.PersonalInformation_Service import PersonalInformation # 个人基本信息
from service.InformationSummary_Service import InformationSummary # 信息概要
from service.TransactionDetails_Service import TransactionDetails # 信贷交易明细
from service.QueryInfomation_Service import QueryInfomation # 查询记录

from service.Base_Service import Result # 返回结果存储
from service.InitHtml_Service import InitHtml # 初始化HTML

class ReportAnalysis(BaseHandler):
    def post(self):
        self._filepath = self.get_argument('filepath', default=None)

        if self._filepath == None or self._filepath == '':
            self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_Params_Error,
                                           mssage=JsonUtil.Constants.Msg_Params_Error.format('filepath',self._filepath)))
            self.flush()

        else:
            filepath = self._filepath
            isFile = False
            try :
                with open(filepath, 'rb') as f:
                    htmlhandle = f.read()
                    f.close()
                    isFile = True
            except IOError as e:
                self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_File_Error,
                                               mssage = JsonUtil.Constants.Msg_File_Error))
                self.flush()

            if isFile:
                try :
                    html = InitHtml(htmlhandle)
                    asslysis = ['PersonalInformation',
                                'InformationSummary',
                                'TransactionDetails',
                                'QueryInfomation'
                                ]
                    maxconnections = len(asslysis) #最大并发数
                    semlock = threading.BoundedSemaphore(maxconnections)
                    for i in range(maxconnections):
                        semlock.acquire()
                        t = threading.Thread(target=eval(asslysis[i]),args=(html.menu_dict,))
                        semlock.release()
                        t.start()
                    # PersonalInformation(html.menu_dict)
                    # InformationSummary(html.menu_dict)
                    # TransactionDetails(html.menu_dict)
                    # QueryInfomation(html.menu_dict)
                    result = Result.get_result()
                    Result.clear_result()
                    self.write(JsonUtil.build_json(report = result,
                                                   code=JsonUtil.Constants.Code_Success,
                                                   mssage=JsonUtil.Constants.Msg_Success))
                    self.flush()
                    self.finish()
                except :
                    self.write(JsonUtil.build_json(code=JsonUtil.Constants.Code_Analysis_Error,
                                                   mssage=JsonUtil.Constants.Msg_Analysis_Error
                                                   ))
                    self.flush()


        # import json
        # outpath = r'/Users/zhangpengcheng/Documents/量化派代码管理/credit_report/html/provinces.json'
        # with open(outpath,"w+",encoding="utf-8") as  f:
        #     _json = json.dumps(Result.get_result())
        #     f.write(_json)
        #     f.close()



        # filepath = r'/Users/zhangpengcheng/Documents/量化派代码管理/credit_report/html/一代征信报告/432325197803211379.html'
        # filepath = r'/Users/zhangpengcheng/Documents/量化派代码管理/credit_report/html/一代征信报告/13082119950823527X.htm'
        # filepath = r'/Users/zhangpengcheng/Documents/量化派代码管理/credit_report/html/一代征信报告/32052219780226051X.htm'
        # filepath = r'/Users/zhangpengcheng/Documents/量化派代码管理/credit_report/html/一代征信报告/140427198607030038.htm'
        # filepath = r'/Users/zhangpengcheng/Documents/量化派代码管理/credit_report/html/一代征信报告/330682198805122815.htm'
        # filepath = r'/Users/zhangpengcheng/Documents/量化派代码管理/credit_report/html/一代征信报告/440421198210078001.html'



    # def run(self):
    #     if self._target is not None:
    #         self._return = self._target(*self._args, **self._kwargs)
    #
    # def get_return(self):
    #     try:
    #         return self._return
    #     except Exception:
    #         return None
    #
    # def join(self):
    #     threading.Thread.join(self)
    #     return self._return