# -*- coding:utf-8 -*-

import json
from collections import defaultdict
import bs4
import pandas as pd
from service.Base_Service import Base,Result


class PersonalInformation(Base):
    """个人基本信息"""
    def __init__(self,html):
        Base.__init__(self,html)

        if '个人基本信息' in self.menu_dict.keys():
            self.menu_personalInformation = self.get_menuDetail_personalInformation(self.menu_dict['个人基本信息'])  # 个人基本信息
            Result.set_result(self.get_Logic(self.menu_personalInformation))
        else:
            Result.set_result({'个人基本信息':None})
    def get_Logic(self,tag):
        result = {}
        if '身份信息' in tag.keys():
            result.update(self.get_information_Identity(tag,'身份信息'))
        if '居住信息' in tag.keys():
            result.update(self.get_information_Residential(tag,'居住信息'))
        if '职业信息' in tag.keys():
            result.update(self.get_information_Occupation(tag,'职业信息'))
        return result

    def get_information_Identity(self,tag,name):
        """身份信息"""
        result = {name:{}}
        tag_msg = tag[name][0].tbody.children
        msg = self.get_json(tag_msg)
        for k,v in msg.items():
            for i in v:
                result[name].update(i)
        result.update(result)
        return result

    def get_information_Residential(self,tag,name):
        """居住信息"""
        result = {name:{}}
        tag_msg = tag[name][0].tbody.children
        msg = self.get_json(tag_msg)
        result[name] = msg[0]
        return result

    def get_information_Occupation(self,tag,name):
        """职业信息"""
        result = {name:{}}
        tag_msg = tag[name][0].tbody.children
        msg = self.get_json(tag_msg)
        if msg :
            basic = pd.read_json(json.dumps(msg[0]))
            details =  pd.read_json(json.dumps(msg[1]))
            df = pd.merge(basic,details,on='编号',how = 'left')
            js = df.to_dict(orient='records')
            result[name] = js
        return result

    def get_json(self,tag):
        result = defaultdict(list)
        key = []
        _num = 0
        for tr in tag:
            index = 0
            if isinstance(tr,bs4.element.Tag):
                tds = tr.find_all('td')
                value = []
                #         key = []
                td_num = len(tds)
                for td in tds:
                    for m in td.stripped_strings:
                        if td.get('style') == None:
                            key.append(m)
                        else:
                            value.append(m)
                        index+=1

                if len(key)!=td_num:
                    key = key[len(key)-td_num:]
                    _num += 1
                if value:
                    result[_num].append(dict(zip(key,value)))
        return result

if __name__ == '__main__':
    PersonalInformation()