# -*- coding:utf-8 -*-

from utils import JsonUtil
from handler.Base_Handler import BaseHandler
from config import settings

class UpLoadFiles(BaseHandler):
    def post(self):
        self._filepath = self.get_argument('filepath', default=None)

        if self._filepath == None or self._filepath == '':
            self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_Params_Error,
                                           mssage=JsonUtil.Constants.Msg_Params_Error.format('filepath',self._filepath)))
            self.flush()

        else:
            filepath = self._filepath
            isFile = False
            try :
                with open(filepath, 'rb') as f:
                    with open(settings.HTML_PATH+'/'+self._filepath.split('/')[-1],'wb+') as f_to:
                        f_to.write(f.read())
                        f_to.close()
                        self.write(JsonUtil.build_json(code=JsonUtil.Constants.Code_Success,
                                                       mssage=JsonUtil.Constants.Msg_Success,
                                                       report='文件上传成功'
                                                       ))
                    f.close()
                self.flush()
                self.finish()

            except IOError as e:
                self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_FileUp_Error,
                                               mssage = JsonUtil.Constants.Msg_FileUp_Error))
                self.flush()

