# -*- coding:utf-8 -*-

import threading
from utils import JsonUtil
from handler.Base_Handler import BaseHandler
import json
from config import settings
from service.PersonalInformation_Service import PersonalInformation # 个人基本信息
from service.InformationSummary_Service import InformationSummary # 信息概要
from service.TransactionDetails_Service import TransactionDetails # 信贷交易明细
from service.QueryInfomation_Service import QueryInfomation # 查询记录

from service.Base_Service import Result # 返回结果存储
from service.InitHtml_Service import InitHtml # 初始化HTML

class ReportAnalysis(BaseHandler):
    def post(self):
        self._filepath = self.get_argument('filename', default=None)
        self._isdownload = self.get_argument('isdownload',default=None)
        if self._filepath == None or self._filepath == '':
            self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_Params_Error,
                                           mssage=JsonUtil.Constants.Msg_Params_Error.format('filepath',self._filepath)))
            self.flush()

        else:
            filepath = settings.HTML_PATH+'/'+self._filepath
            isFile = False
            try :
                with open(filepath, 'rb') as f:
                    htmlhandle = f.read()
                    f.close()
                    isFile = True
            except IOError as e:
                self.write(JsonUtil.build_json(code = JsonUtil.Constants.Code_File_Error,
                                               mssage = JsonUtil.Constants.Msg_File_Error))
                self.flush()

            if isFile:
                try :
                    html = InitHtml(htmlhandle)
                    asslysis = ['PersonalInformation',
                                'InformationSummary',
                                'TransactionDetails',
                                'QueryInfomation'
                                ]
                    maxconnections = len(asslysis) #最大并发数
                    semlock = threading.BoundedSemaphore(maxconnections)
                    for i in range(maxconnections):
                        semlock.acquire()
                        t = threading.Thread(target=eval(asslysis[i]),args=(html.menu_dict,))
                        semlock.release()
                        t.start()
                    # PersonalInformation(html.menu_dict)
                    # InformationSummary(html.menu_dict)
                    # TransactionDetails(html.menu_dict)
                    # QueryInfomation(html.menu_dict)
                    result = Result.get_result()
                    Result.clear_result()

                    # '/Users/zhangpengcheng/Documents/量化派代码管理/credit-report-api/html/data.json'
                    if self._isdownload:
                        with open(settings.TO_JSON+'/'+self._filepath.split('/')[-1]+'.json', 'w',encoding='utf8') as file_obj:
                            file_obj.write(json.dumps(result,ensure_ascii=False))
                            file_obj.close()

                    self.write(JsonUtil.build_json(report = result,
                                                   code=JsonUtil.Constants.Code_Success,
                                                   mssage=JsonUtil.Constants.Msg_Success))
                    self.flush()
                    self.finish()
                except :
                    self.write(JsonUtil.build_json(code=JsonUtil.Constants.Code_Analysis_Error,
                                                   mssage=JsonUtil.Constants.Msg_Analysis_Error
                                                   ))
                    self.flush()

