# -*- coding:utf-8 -*-

'''
服务启动接口
'''
from tornado.web import Application
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
import tornado.log
import logging
import tornado.options
from config import settings as URL

# from handler import LoanDueRateHandler
from tornado.options import define, options

from handler import ReportAnalysis_Handler,UpLoadFiles_Handler

from tornado.options import define, options

define("port", default=20010, help="run on the given port ", type=int)
define("log_path", default='/tmp', help="log path ", type=str)

class LogFormatter(tornado.log.LogFormatter):
    def __init__(self):
        print('%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s')
        super(LogFormatter, self).__init__(
                fmt='%(color)s[%(asctime)s %(filename)s:%(funcName)s:%(lineno)d %(levelname)s]%(end_color)s %(message)s',
                datefmt='%Y-%m-%d %H:%M:%S'
        )

def apps():
    return Application([
        (URL.url_reportanalysis, ReportAnalysis_Handler.ReportAnalysis),
        (URL.url_uploadfiles, UpLoadFiles_Handler.UpLoadFiles),

    ])

if __name__ == "__main__":

    app = apps()
    server = HTTPServer(app)
    [i.setFormatter(LogFormatter()) for i in logging.getLogger().handlers]
    tornado.options.parse_command_line()

    # #== 本地调试
    app.listen(20011)
    IOLoop.instance().start()


    # tornado.options.parse_command_line()
    # app = apps()
    # http_server = tornado.httpserver.HTTPServer(app)
    # http_server.bind(options.port)
    # http_server.start()
    # tornado.ioloop.IOLoop.instance().start()