# -*- coding:utf-8 -*-

import bs4
import re
from collections import defaultdict

class Result:
    """html to json"""
    result = {}
    html = None
    @classmethod
    def set_result(cls,result):
        cls.result.update(result)

    @classmethod
    def get_result(cls):
        return cls.result

    @classmethod
    def clear_result(cls):
        cls.result = {}
        return cls.result

    @classmethod
    def get_htmlMsg(cls,html):
        if cls.html == None:
            cls.html = 1
        return cls.html


class Base(object):
    def __init__(self,html):
        self.menu_dict = html
        pass

    def get_menuDetail(self,tag):
        """按报告内部小标题拆分"""
        _dict = defaultdict(list)
        key = None
        for i in range(len(tag)):
            index = []
            for m in tag[i].stripped_strings:
                #             ret=re.findall(r'(\（一\）|\（二\）)[\ ]?(\w+)',m)
                # ret=re.findall(r'(\（\S\）)[\ ]?(\w+)',m)
                ret=re.findall(r'(\（[\u4E00-\u9FA5]\）)[\ ]?(\w+)',m)
                if ret:
                    key = ret[0][1]
                    index.append(i)
            if key:
                if i not in index:
                    _dict[key].append(tag[i])
        return dict(_dict)

    def get_menuDetail_personalInformation(self,tag):
        """按报告内部小标题拆分 - 公共信息明细"""
        _dict = defaultdict(list)
        key = None
        for i in tag:
            if i.table==None:
                if i.b:
                    key = i.b.get_text()
            else:
                _dict[key].append( i.table)
        return _dict

    def get_menuDetail_queryInformation(self,tag):
        """按报告内部小标题拆分 - """
        _dict = defaultdict(list)
        key = None
        for i in tag:
            if i.table==None:
                if i.b:
                    key = i.b.get_text()
            else:
                _dict[key].append( i.table)
        return _dict

    def get_table(self,tag):
        """把table 转list"""
        tag_list = []
        table = tag.tbody
        for i,t in enumerate(table):
            if isinstance(t,bs4.element.Tag):
                tag_list.append(t)
        return tag_list

    def get_json(self,tag):
        """获取table解析后的json , 支持表头与值循环"""
        result = defaultdict(list)
        _key = []
        # _colspan=0
        index = 0
        for i,val in enumerate(tag):
            tds = val.find_all('td')
            if i %2 == 0:
                key = []
                for ii ,td in enumerate(tds):
                    if isinstance(td,bs4.element.Tag):
                        # _colspan = td.get('colspan')
                        tm = ''
                        for k in td.stripped_strings:
                            tm+= k
                    key.append(tm)
                _key.append(key)
                index+=1
            else:
                if len(_key[index-1]) == len(tds):
                    for ii ,td in enumerate(tds):
                        if isinstance(td,bs4.element.Tag):
                            value = ''
                            for k in td.stripped_strings:
                                value+=k
                        result[_key[index-1][ii]] = value
                else:
                    value = []
                    for ii ,td in enumerate(tds):
                        value.append(td.get_text().strip())
                    result[_key[index-1][0]] = value
        return dict(result)

    # def get_json_tableList(self,tag):
    #     """支持 table 列表形式 存储
    #     ::return list
    #     """
    #     _result = []
    #     tag = tag.tbody
    #     for i in tag:
    #         td = tag.findAll('td')
    #         _v = []
    #         for t in td:
    #             if t.get('style'):
    #                 for v in t.stripped_strings:
    #                     _v.append(v)
    #         _result.append(_v)
    #     return _result