import re
from collections import defaultdict

import bs4
import pandas as pd

from service.Base_Service import Base,Result


class TransactionDetails(Base):
    """信贷交易明细"""
    def __init__(self,filepath):
        Base.__init__(self,filepath)
        if '信贷交易信息明细' in self.menu_dict.keys():
            self.menu_transactionDetails = self.get_menuDetail(self.menu_dict['信贷交易信息明细'])  # 信贷交易信息明细
            self.menu_transactionDetailsType = {}
            for k,value in self.menu_transactionDetails.items():
                # if k == '贷记卡':
                self.menu_transactionDetailsType[k] = self.get_menuDetailsList(value)
            Result.set_result(self.get_Logic(self.menu_transactionDetailsType))
        else:
            Result.set_result({'信贷交易信息明细':None})


    def get_Logic(self,tag):
        result = {}
        if '贷款' in tag.keys():
            result.update(self.get_Loan_Details(tag['贷款']))
        if '贷记卡' in tag.keys():
            result.update(self.get_DebitCard_Details(tag['贷记卡']))
        if '准贷记卡' in tag.keys():
            result.update(self.get_DebitCard_Details(tag['准贷记卡']))
        return result

    def get_menuDetailsList(self,tag):
        """交易信息明细小标题拆分"""
        _result = []
        _temp = []
        for i in tag:
            if i.td.attrs:
                try :
                    if i.div['align'] == 'left':
                        #                         print(list( re.findall('([0-9]\d{0,2})[\.]{1}(\S+)',i.div.get_text())[0]))
                        _temp.extend(list( re.findall('([0-9]\d{0,2})[\.]{1}(\S+)',i.div.get_text())[0]))
                    elif i.div['align'] == 'center':
                        _temp.append(i)
                except:
                    _temp.append(None)
            else:
                if i.table:
                    _temp.append(i) #
                if _temp:
                    _result.append(_temp)
                _temp = []
        return _result

    def get_Loan_Details(self,tag):
        """贷款明细拆分拆分"""
        result = {'贷款':{}}
        _result = []
        for v in tag:
            _json = {}
            _json['序号'] =v[0]
            _json['描述'] =v[0]+'.'+v[1]
            r1 = re.findall("账户状态为“(\S+)”",v[1])
            if r1:
                # r = re.findall("(\d{4}年\d{1,2}月\d{1,2}日)([\S+]*)发放的([\S+]*)元\（([\S+]*)\）([\S+]*)，业务号([\S+]{0,1})，([\S+]*)，([\d]*)期，([\S+]*)。截至(\d{4}年\d{1,2}月\d{1,2}日)[\S+]*账户状态为“(\S+)”",v[1])
                r = re.findall("(\d{4}年\d{1,2}月\d{1,2}日)([\S+]*)发放的(.*?)元\（([\S+]*)\）(.*?)，业务号(.*?)，(.*?)，(.*?)。截至(.*?)，账户状态为“(.*?)”",v[1])
                if r:
                    r = r[0]
                    _json['银行名称'] = r[1]
                    _json['贷款金额'] = r[2]
                    _json['贷款类型'] = r[4]
                    terms = r[7].split('，')
                    if len(terms)>1:
                        term = re.findall('(.*?)期',terms[0])[0]
                        _json['贷款期数'] = term
                    else:
                        _json['贷款期数'] = None
                    _json['是否抵押'] = r[6]
                    _json['起始时间'] = r[0]
                    _json['终止时间'] = r[8]
                    _json['账户状态'] = r[9]
            else:
                # r = re.findall("(\d{4}年\d{1,2}月\d{1,2}日)([\S+]*)发放的([\S+]*)元\（([\S+]*)\）([\S+]*)，业务号([\S+]{0,1})，([\S+]*)，([\d]*)期，([\S+]*)，(\d{4}年\d{1,2}月\d{1,2}日)[\S+]*[\S+]*(\d{4}年\d{1,2}月\d{1,2}日)",v[1])
                r =  re.findall("(\d{4}年\d{1,2}月\d{1,2}日)([\S+]*)发放的(.*?)元\（([\S+]*)\）(.*?)，业务号(.*?)，(.*?)，(.*?)，(\d{4}年\d{1,2}月\d{1,2}日)到期。截至(\d{4}年\d{1,2}月\d{1,2}日)",v[1])
                if r:
                    r = r[0]
                    _json['银行名称'] = r[1]
                    _json['贷款金额'] = r[2]
                    _json['贷款类型'] = r[4]
                    # _json['贷款期数'] = r[7]
                    terms = r[7].split('，')
                    if len(terms)>1:
                        term = re.findall('(.*?)期',terms[0])[0]
                        _json['贷款期数'] = term
                    else:
                        _json['贷款期数'] = None
                    _json['是否抵押'] = r[6]
                    _json['起始时间'] = r[0]
                    _json['终止时间'] = r[9]

            if v[2] != None:
                table_tag = self.get_table(v[2])
                table_json = self.get_json_LoanDetails(table_tag)
                key_name = table_json.keys()
                # rename = ''
                plan = ''
                overdue = ''
                temp_json = {}
                for name in key_name:
                #     r = re.findall("(\d{4}年\d{1,2}月)-(\d{4}年\d{1,2}月)的([\S+]*)",name)
                #     if r :
                #         temp_json['近24个月的还款记录-开始时间'] =r[0][0]
                #         temp_json['近24个月的还款记录-截至时间'] =r[0][1]
                #         rename = name
                # if rename:
                #     table_json['近24个月的还款记录-各期还款记录'] = table_json.pop(rename)
                # if temp_json:
                #     table_json.update(temp_json)
                    r = re.findall("(\d{4}年\d{1,2}月)-(\d{4}年\d{1,2}月)的([\S+]*)",name)
                    if r :
                        if r[0][2] == '还款记录':
                            temp_json['近24个月的还款记录-开始时间'] =r[0][0]
                            temp_json['近24个月的还款记录-截至时间'] =r[0][1]
                            plan = name
                        if r[0][2] == '逾期记录':
                            overdue = name

                if plan:
                    table_json['近24个月的还款记录-各期还款记录'] = table_json.pop(plan)
                if overdue:
                    del table_json[overdue]

                if temp_json:
                    table_json.update(temp_json)

                if '逾期记录' in table_json.keys():
                    df = pd.DataFrame(table_json['逾期记录'])
                    df = df.loc[(df['逾期持续月数']!='--')&(df['逾期月份']!='--')&(df['逾期金额']!='--')]
                    df['逾期金额'] = df['逾期金额'].apply(lambda x : float(x.replace(',','')))

                    table_json['逾期记录'] = df.to_dict(orient='records')

                    table_json['近5年逾期记录'] = table_json.pop('逾期记录')

                _json.update(table_json)
            _result.append(_json)
        result['贷款'] = _result
        return result

    def get_DebitCard_Details(self,tag):
        """贷记卡明细拆分"""
        result = {'贷记卡':{}}
        _result = []
        for v in tag:
            _json = {}
            _json['序号'] =v[0]
            _json['描述'] =v[0]+'.'+v[1]
            r =  re.findall("(\d{4}年\d{1,2}月\d{1,2}日)(.*?)发放的(.*?)，业务号(.*?)，授信额度[折合人民币]{0,5}(.*?)元，共享授信额度[折合人民币]{0,5}(.*?)元，(.*?)[，|。]{1}截至(\d{4}年\d{1,2}月\d{1,2}日)，(账户状态为“[\u4E00-\u9FA5]{1,}”)*",v[1])
            if r :
                r = r[0]
                _json['银行名称'] = r[1]
                _json['授信金额'] = r[4]
                _json['共享授信金额'] = r[5]
                _json['授信时间'] = r[0]
                _json['截止时间'] = r[7]
                if r[8]:
                    r_temp = re.findall('账户状态为“(.*?)”',r[8])[0]
                    _json['账户状态'] = r_temp

            if v[2] != None:
                table_tag = self.get_table(v[2])
                table_json = self.get_json_DebitCard(table_tag)
                key_name = table_json.keys()
                plan = ''
                overdue = ''
                temp_json = {}
                for name in key_name:
                    r = re.findall("(\d{4}年\d{1,2}月)-(\d{4}年\d{1,2}月)的([\S+]*)",name)
                    if r :
                        if r[0][2] == '还款记录':
                            temp_json['近24个月的还款记录-开始时间'] =r[0][0]
                            temp_json['近24个月的还款记录-截至时间'] =r[0][1]
                            plan = name
                        if r[0][2] == '逾期记录':
                            overdue = name

                if plan:
                    table_json['近24个月的还款记录-各期还款记录'] = table_json.pop(plan)
                if overdue:
                    del table_json[overdue]

                if temp_json:
                    table_json.update(temp_json)

                if '逾期记录' in table_json.keys():
                    df = pd.DataFrame(table_json['逾期记录'])
                    df = df.loc[(df['逾期持续月数']!='--')&(df['逾期月份']!='--')&(df['逾期金额']!='--')]
                    df['逾期金额'] = df['逾期金额'].apply(lambda x : float(x.replace(',','')))
                    table_json['逾期记录'] = df.to_dict(orient='records')
                    table_json['近5年逾期记录'] = table_json.pop('逾期记录')

                if '账户状态' in table_json.keys() and table_json['账户状态'] == '正常':
                    if '账户状态' in _json.keys():
                        del _json['账户状态']

                _json.update(table_json)
            _result.append(_json)
        result['贷记卡'] = _result
        return result

    def get_json_DebitCard(self,tag):
        result = defaultdict(dict)
        key = []
        value = []
        value_list = []

        temp_key = None
        for i,val in enumerate(tag):
            tds = val.find_all('td')
            # tds_len = len(tds)
            # next_sibling = val.next_sibling
            # if (next_sibling == ' ' or next_sibling =='\n' ) and next_sibling!=None:
            #     next_sibling = val.next_sibling.next_sibling
                # tds_next = next_sibling.find_all('td')
                # tds_next_len = len(next_sibling.find_all('td'))

            for ii ,td in enumerate(tds):
                #             print(tds_len,tds_next_len,'---1---')
                if isinstance(td,bs4.element.Tag):
                    if val.get('align') or td.get('colspan') == '24':
                        tm = ''
                        for k in td.stripped_strings:
                            tm+= k
                        key.append(tm)
                    else:
                        tm = ''
                        for k in td.stripped_strings:
                            tm+= k
                        value.append(tm)
                        if len(key) == 0 and temp_key:
                            value_list.append(tm)
                            r = re.findall('\d{4}年\d{1,2}月-\d{4}年\d{1,2}月的([\S+]*)',temp_key)
                            if r:
                                r = r[0]
                                if result[temp_key][ii] not in result[r].keys():
                                    result[r][result[temp_key][ii]] = []
                                result[r][result[temp_key][ii]].append(value_list[ii])

            if key and value:
                if len(key) == len(value):
                    result.update(dict(zip(key,value)))
                else:
                    result.update(dict({key[0]:value}))
                    temp_key = key[0]
                key=[]
                value = []
        return dict(result)


    def get_json_LoanDetails(self,tag):
        result = defaultdict(dict)
        key = []
        value = []
        value_list = []

        temp_key = None
        for i,val in enumerate(tag):
            tds = val.find_all('td')
            # tds_len = len(tds)
            # next_sibling = val.next_sibling
            # if (next_sibling == ' ' or next_sibling =='\n' ) and next_sibling!=None:
            #     next_sibling = val.next_sibling.next_sibling
            # tds_next = next_sibling.find_all('td')
            # tds_next_len = len(next_sibling.find_all('td'))

            for ii ,td in enumerate(tds):
                #             print(tds_len,tds_next_len,'---1---')
                if isinstance(td,bs4.element.Tag):
                    if td.get('align') or td.get('colspan') == '24':
                        tm = ''
                        for k in td.stripped_strings:
                            tm+= k
                        key.append(tm)
                    else:
                        tm = ''
                        for k in td.stripped_strings:
                            tm+= k
                        value.append(tm)
                        if len(key) == 0 and temp_key:
                            value_list.append(tm)
                            r = re.findall('\d{4}年\d{1,2}月-\d{4}年\d{1,2}月的([\S+]*)',temp_key)
                            if r:
                                r = r[0]
                                if result[temp_key][ii] not in result[r].keys():
                                    result[r][result[temp_key][ii]] = []
                                result[r][result[temp_key][ii]].append(value_list[ii])

            if key and value:
                if len(key) == len(value):
                    result.update(dict(zip(key,value)))
                else:
                    result.update(dict({key[0]:value}))
                    temp_key = key[0]
                key=[]
                value = []
        return dict(result)

if __name__ == '__main__':
    TransactionDetails()