# -*- coding:utf-8 -*-

import json
from collections import defaultdict
import bs4
import pandas as pd
from service.Base_Service import Base,Result


class Heads(Base):
    """表头信息 1. 调查信息 2. 被调用户信息"""
    def __init__(self,html):
        Base.__init__(self,html)
        Result.set_result({'表头':self.get_Logic(self.menu_dict)})
        pass

    def get_Logic(self,tag):
        result = {}
        result.update(self.get_heads_report(tag[0]))
        result.update(self.get_heads_user(tag[1]))
        return result

    def get_heads_report(self,tag):
        """报告信息"""
        result = {}
        tds = tag.table.find_all('td')
        for ii, i in enumerate(tds):
            if isinstance(i,bs4.element.Tag):
                if i.get('class') != None and 'high' in i.get('class'):
                    tm = ''
                    for msg in i.stripped_strings:
                        tm+=msg
                    tm = tm.split(':')
                    result.update({tm[0]:tm[1]})
        return result

    def get_heads_user(self,tag):
        """用户信息"""
        result = {}
        table = self.get_table(tag)
        result.update(self.get_json(table))
        return result

    def get_information_Identity(self,tag,name):
        """身份信息"""
        result = {name:{}}
        tag_msg = tag[name][0].tbody.children
        msg = self.get_json(tag_msg)
        for k,v in msg.items():
            for i in v:
                result[name].update(i)
        result.update(result)
        return result