const path = require('path')
const logDir = path.resolve(process.cwd(), './logs')

module.exports = {
  port: 80,

  logProperty: "collection",

  redis: {
    api: 'redis://redis:6379/1'
  },

  LOCK_EXPIRE: 5, // url锁定5s
  SNAP_EXPIRE: 3 * 24 * 60 * 60, // 缓存3天

  log4js: {
    appenders: [
      { type: 'console' }, //控制台输出
      {
        type: 'dateFile', // 项目日志
        filename: `${logDir}/statistics.log`,
        pattern: '.yyyy-MM-dd',
        category: 'app',
        layout: { type: 'basic' }
      },
      {
        type: 'dateFile', // 日志上传
        filename: `${logDir}/statistics-up.log`,
        pattern: '.yyyy-MM-dd',
        category: 'upload',
        layout: {
          type: 'pattern',
          pattern: "%m"
        }
      }
    ]
  }
}