# coding=UTF-8
from __future__ import print_function
import io
import yaml
import fileinput
import os
import os.path
import re
import copy
import sys
# import requests

opApiHost = 'http://172.30.220.22:3003'
f = io.open('replace_config.yaml', 'r', encoding='utf-8')
res = yaml.load(f)
print("全部配置信息:", res)

# 查看配置中是否有当前项目
env = os.environ
project = env.get('SYSTEM_NAME')
distPath = os.path.abspath(project + '/dist')
config = res.get(project, res.get('common'))
print(project, "的配置信息:", config)
print("dist路径:", distPath)

# 根据内容进行替换
namespace = env.get('NAMESPACE')
print('namespace:', namespace)

files = []
acceptType = {'.html', '.js', '.css'}
def findFile (dir):
  if os.path.isfile(dir):
    suffix = os.path.splitext(dir)[-1]
    if (suffix in acceptType):
      files.append(dir)
    return
  else:
    for sub in os.listdir(dir):
      findFile(dir + '/' + sub)

# 过滤符合要求的文件路径
findFile(distPath)

# 替换文件中的内容
for file in files:
  for line in fileinput.input(file, inplace = 1):
    for item in config:
      if not config[item]:
        continue

      rule = copy.deepcopy(config[item])
      if rule.get('useNamespace', None) and rule['to']:
        rule['to'] = '-' + namespace + rule['to']

      if rule.get('useDomain',None):
        # domain = requests.get(opApiHost + '/proconfig/get_host?system_name=' + project)
        # domain = domain.json['data'].split('.')[0]
        domain = sys.argv[1].split('.')[0]
        print ('domain:', domain)
        rule['to'] = '//' + domain + rule['to']

      if rule['reg']:
        p = re.compile(r'' + rule['reg'])
        line = re.sub(p, rule['to'], line)

    print(line, end = '')
  fileinput.close()

f.close()