const project = 'business-watcher'
const dir = 'logs'

module.exports = {
  log4js: {
    appenders: {
      out: { type: 'stdout' },
      app: { type: 'dateFile', filename: `${dir}/${project}.log`, daysToKeep: 3, compress: true },
      error: { type: 'dateFile', filename: `${dir}/${project}.error.log`, daysToKeep: 3, compress: true },
      just_errors: { type: 'logLevelFilter', appender: 'error', level: 'error' }
    },
    categories: {
      default: { appenders: ['out', 'app', 'just_errors'], level: 'info' }
    }
  },

  mongo: {
    api: 'mongodb://192.168.4.50:27017/monitor'
  }
}