# coding=UTF-8
from __future__ import print_function
from functools import partial
import io
import yaml
import fileinput
import os
import os.path
import re
import copy
import sys
import string
import logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger("mylog")

f = io.open('replace_config.yaml', 'r', encoding='utf-8')
res = yaml.load(f)
logger.info("全部配置信息:" + str(res))
f.close()

# 获取当前项目的配置
env = os.environ
project = env.get('SYSTEM_NAME')
config = res.get(project, res.get('common'))
config = sorted(config.items(), key=lambda rule: (rule[1]['order'], rule[0]))
logger.info("当前project: " + str(project))
logger.info("配置信息: " + str(config))

namespace = env.get('NAMESPACE')
logger.info('namespace: ' + namespace)
logger.info('host: ' + str(sys.argv[1]))

files = []
acceptType = {'.html', '.js', '.css'}
def findFile (dir):
  if os.path.isfile(dir):
    suffix = os.path.splitext(dir)[-1]
    if (suffix in acceptType):
      files.append(dir)
    return
  else:
    for sub in os.listdir(dir):
      findFile(dir + '/' + sub)

distPaths = []
distPaths.append(os.path.abspath(project + '/dist'))
# distPaths.append(os.path.abspath('/Users/zhiyong/IdeaProjects/qg/vcc-ui/dist'))

# 过滤符合要求的文件路径
for distPath in distPaths:
  logger.info('dist路径' + distPath)
  findFile(distPath)

def _replayHanlder(rule, to, matched):
  logger.info("规则:" + rule + ", 匹配到:" + str(matched.group()) + ", 替换为:" + to);
  return to;

# 替换文件中的内容
if  project == 'recruiting-management' or project == 'recruiting-ui':
  for file in files:
    logger.info('开始替换文件:' + str(file))
    for line in fileinput.input(file, inplace = 1):
      p = re.compile(r'' + 'api.stantoo.com')
      to = 'recruitapi-' + namespace + '.liangkebang.net'
      _handler1 = partial(_replayHanlder, 'api.stantoo.com', to)
      line = re.sub(p, _handler1, line)
      print(line, end = '')
    fileinput.close()

else:
  for file in files:
    logger.info('开始替换文件:' + str(file))
    for line in fileinput.input(file, inplace = 1):
      for item in config:
        rule = copy.deepcopy(item[1])
        if rule.get('useNamespace', None) and rule['to']: 
          rule['to'] = '-' + namespace + rule['to']

        if rule.get('useHost', None):
          domain = sys.argv[1].split('.')[0]
          rule['to'] = '//' + domain + rule['to']

        if rule['reg']:
          p = re.compile(r'' + rule['reg'])
          _handler1 = partial(_replayHanlder, rule['reg'], rule['to'])
          line = re.sub(p, _handler1, line)

      print(line, end = '')
    fileinput.close()

logger.info('完成')

