
const path = require('path')
const logDir = path.resolve(process.cwd(), './logs')

module.exports = {
  port:80,
	accessOrigin : [".xyqb.com",".q-gp.com", ".quantgroup.cn", ".liangkebang.com"],
  api: {
    passport_api: 'http://passportapi.domain.com',
    xjd_api: 'http://api-zhenghang.liangkebang.com',
    redpacket_api: 'http://redpacket.domain.com',
    score_api: 'http://scoreapi.domain.com',
    auth_api: 'https://auth.domain.com',
    flow_api: 'http://flow.domain.com',
    mall_api: 'http://mallapi.domain.com',
    bt_api: 'http://btapi.domain.com',
    appbackend_api: 'http://sappbackend.domain.com',
    pay_api: 'http://payapi.domain.com',
	  sc_api: 'http://scapi-zhenghang.liangkebang.com'
  },

  redis: {
    api: 'redis://redis:6379/1'
  },

  //极速版
  appbackend_redis: {
    host: 'redis',
    port: 6379
    // sentinels: [
    //   { host: 'appbackend-redis1.quantgroups.com', port: 26379 },
    //   { host: 'appbackend-redis2.quantgroups.com', port: 26379 },
    //   { host: 'appbackend-redis3.quantgroups.com', port: 26379 }
    // ],
    // name: 'mymaster'
  },

  xyqbapiServer: {
    root: 'http://api-zhenghang.liangkebang.com',
    loanHomeStatus: '/v3/speed/app/home_status',
    receiveToken2: '/ex/login/receive_token2',
  },

  xyqbDisplay: {
    host: 'http://display-config-zhenghang.liangkebang.com',
    getLoanConfig: '/ex/loan_config'
  },

  blankNote: {
    root: 'http://btapi.xyqb.com',
    receiveToken: '/ex/login/btreceive_token',
  },

  // Secret for session, you will want to change this and make it an environment variable
  secrets: {
    session: 'xyqb-app-api-secret',
    salt: '_lkb'
  },

  gateway: {
    secretKey: 'z-user-secret',
    phoneKey: 'z-user-phone-no',
    secretValue: 'z.h,w44RXMu4XL#dq_%@ZX,u*gd]zVhmdks@H8krq*Gn-CC:6>YTHX_Kh=_#D7LR'
  },

  passport: {
    host: 'http://passportapi-zhenghang.liangkebang.com'
  },

  userCenterApiServer: {
      appLoginUrl: '/app/login2'
  },

  log4js: {
    appenders: {
      out: { type: 'stdout' },
      app: { type: 'dateFile', filename: logDir + '/xyqb-h5-backend.log', daysToKeep: 3, compress: true },
      error: { type: 'dateFile', filename: logDir + '/xyqb-h5-backend.error.log', daysToKeep: 3, compress: true },
      just_errors: { type: 'logLevelFilter', appender: 'error', level: 'error' }
    },
    categories: {
      default: { appenders: ['out', 'app', 'just_errors'], level: 'info' }
    }
  },

  qiniu: {
    domain: 'https://mapi.domain.com',
    ACCESS_KEY: 'e2S74rOnpqNz1rkZRdgY45c8L988PoARRQ60_6-t',
    SECRET_KEY: 'YYtAEZ2bPDiyNLt2qLKGpaEp0-Thq8tGLrqlBgxY',
    BUCKET: 'app-sync',
  },

  mongo: {
    api: 'mongodb://192.168.4.50:27017/h5_xyqb'
  },

  ocr: {
    auth_api: 'http://operator.liangkebang.com/auth-center/api/ocr/h5/auth_url.json',
    query_api: 'http://operator.liangkebang.com/auth-center/h5/api/ocr/auth.json',
    key: 'wd8bRaLf1nbiMDvPpM1fP9sA2mVSmmpy'
  },

  rabbitmq: {
    mall_api: 'amqp://qa:qatest@rabbitmq:5672/mall'
  },	
	
	zookeeper: {
				api: 'zookeeper:2181',
	      znode: ['/grpc/help_center']
  },
  
  accessOrigin: [".xyqb.com", ".q-gp.com", ".quantgroup.cn", ".liangkebang.com"]
}
