function string.split(str)
  local splitlist = {};
  string.gsub(str, '[^,]+', function(w) table.insert(splitlist, w) end )
  return splitlist;
end

function isInTable(value, tbl)
  for k,v in ipairs(tbl) do
    if v == value then
    return true;
    end
  end
  return false;
end

local path = ngx.var.normalPath;
local channelPath = ngx.var.channelPath;


local tailNumbers = string.split(ngx.var.tailNumber);
local excludeChannel = string.split(ngx.var.excludeChannel)


local register = string.split(ngx.var.registerChannel);
local merchant = string.split(ngx.var.merchantChannel);


local register_cookie = ngx.var.cookie_registerFrom
local merchant_cookie = ngx.var.cookie_merchantId


local args = ngx.req.get_uri_args()
local register_uri = args['registerFrom']
local merchant_uri = args['merchantId']


local baiTiao = '222';

if (register_uri) then
  isBaitiao = register_uri == baiTiao
else
  isBatitiao = register_cookie == baiTiao
end

if (isBatitiao) then
  return channelPath;
end


if (ngx.var.excludeChannel ~= '' or ngx.var.tailNumber ~= '') then
  local hitExclude = isInTable(register_uri, excludeChannel) or isInTable(register_cookie, excludeChannel)
    or isInTable(merchant_cookie, excludeChannel) or isInTable(merchant_uri, excludeChannel)

  if (hitExclude) then
    return path;
  end


  local hitTailNumber = false
  if ngx.var.cookie_phoneNo then
    for key,value in ipairs(tailNumbers)
    do
      if (string.match(ngx.var.cookie_phoneNo, value..'$')) then
        hitTailNumber = true
        break
      end
    end
  end

  if (hitTailNumber) then
    return channelPath;
  end
end

return channelPath;
