# coding=UTF-8
from __future__ import print_function
import io
import yaml
import fileinput
import os
import os.path
import re
import copy
import sys

f = io.open('replace_config.yaml', 'r', encoding='utf-8')
res = yaml.load(f)
print("全部配置信息:", res)

# 获取当前项目的配置
env = os.environ
project = env.get('SYSTEM_NAME')
distPath = os.path.abspath(project + '/dist')
config = res.get(project, res.get('common'))
config = sorted(config.items(), key=lambda rule: (rule[1]['order'], rule[0]))
print(project, "的配置信息:", config)
print("dist路径:", distPath)

namespace = env.get('NAMESPACE')
print('namespace:', namespace)

files = []
acceptType = {'.html', '.js', '.css'}
def findFile (dir):
  if os.path.isfile(dir):
    suffix = os.path.splitext(dir)[-1]
    if (suffix in acceptType):
      files.append(dir)
    return
  else:
    for sub in os.listdir(dir):
      findFile(dir + '/' + sub)

# 过滤符合要求的文件路径
findFile(distPath)

# 替换文件中的内容
for file in files:
  for line in fileinput.input(file, inplace = 1):
    for item in config:
      rule = copy.deepcopy(item[1])
      if rule.get('useNamespace', None) and rule['to']:
        rule['to'] = '-' + namespace + rule['to']

      if rule.get('useHost', None):
        domain = sys.argv[1].split('.')[0]
        rule['to'] = '//' + domain + rule['to']

      if rule['reg']:
        p = re.compile(r'' + rule['reg'])
        line = re.sub(p, rule['to'], line)

    print(line, end = '')
  fileinput.close()

f.close()