'use strict';


exports.save_by_key = async function () {
    await this.bindDefault();
    this.body = await this.mongo("Tag", this.request.body).saveByKey();
    return
}
exports.save_by_key.__method__ = 'POST';

exports.query = async function () {
    await this.bindDefault();
    let data = {};
    data.project = await this.mongo("Project").findById(this.request.query._id);
    data.data = await this.mongo("Tag").findByProjectId(this.request.query._id);
    this.body = data
    return
}
exports.query.__method__ = 'GET';

exports.delete = async function () {
    await this.bindDefault();
    this.body = await this.mongo("Tag").delete(this.request.query._id);
    return
}
exports.delete.__method__ = "GET";

exports.update_by_id = async function () {
    await this.bindDefault();
    this.body = await this.mongo("Tag").updateById(this.request.query._id, this.request.query);
    return
}
exports.update_by_id.__method__ = "PUT"

exports.resetDefaultProject = async function () {
    await this.bindDefault();
    this.body = await this.mongo("Tag").setDefault(this.request.query._id);
    return
}
exports.resetDefaultProject.__method__ = "PUT"

exports.fix_tag_data = async function () {
    await this.bindDefault();
    let projects = await this.mongo("Project").query();
    for (let item of projects){
        await this.mongo("Tag", {
            title: "默认",
            is_default: 1,
            projects: item._id
        }).saveByKey();
    }

    this.body = { msg: "ok" }
    return 
}
exports.fix_tag_data.__method__ = "GET"