"use strict";

process.env.DEBUG = process.env.DEBUG || '*';

const serverConfig = require('./server.json');
const makeConfig = require('../src/utils').makeConfig;
var os = require('os');
var ifaces = os.networkInterfaces();
let ip = "0.0.0.0";
function getIp() {
    Object.keys(ifaces).forEach(function (ifname) {
        var alias = 0;

        ifaces[ifname].forEach(function (iface) {
            if ('IPv4' !== iface.family || iface.internal !== false) {
                // skip over internal (i.e. 127.0.0.1) and non-ipv4 addresses
                return;
            }
            if (alias >= 1) {
                // this single interface has multiple ipv4 addresses
                // console.log(ifname + ':' + alias, iface.address);
            } else {
                // this interface has only one ipv4 adress
                console.log(ifname,iface.address)
                if (ifname == "eth0" || ifname == "en0") {
                    ip = iface.address;
                }
                // console.log(ifname, iface.address);
            }
            ++alias;
        });
    });
}
getIp();
console.log("配置文件获取IP",ip)
let vhost = {};
vhost[ip] = 'blackPearl';

let path =   {
  // project
  project: './app/',
  // 当直接访问域名时的默认路由
  default_path: {},
  // 如果设置jump为false，则当直接访问域名时不重定向到default_path
  default_jump: {}
}
path.default_path[ip] = "/home/index";
path.default_jump[ip] = true;
    
module.exports = makeConfig({
  // vhost配置
  vhost:vhost,
  // router配置
  router: {
    prefix: {
      test: '/test'
    }
  },

  // proxy配置
  proxy: {
    // 超时配置 
    timeout: 15000
  },

  // controller中请求各类数据前缀和域名的键值对
  api: {
    github_api: 'https://api.github.com/',
    github: 'https://github.com/',
  },

  // mock server配置
  mock: {
    prefix: '/__MOCK__/'
  },

  // 站点相关的配置
  site: {
    env: 'development',
    port: 10085,
    hostname: ip
  },

  // 通用参数，以模板参数的形式传递给模板引擎
  constant: {
    cdn: '',
    domain: {
      // demo: 'http://127.0.0.1:3000'
    },
    // github personal token ，不知道这个配置，完全可以忽略它
    token: "" 
  },

  // 路径相关的配置
  path: path,

  // mongo配置
  mongo: {
    options: {
      // mongoose 配置
    },
    api: {
      'blackPearl': 'mongodb://localhost:27017/blackPearl'
    }
  },

  // 模板引擎配置，默认：swiger
  template: {
    iblog: 'nunjucks'
  },

  // 上传文件配置
  xload: {
    path: 'files/',
    upload: {
      encoding: 'utf-8',
      maxFieldsSize: 2 * 1024 * 1024,
      maxFields: 1000,
      keepExtensions: true
    },
    download: {}
  },

  // csrf配置
  csrf: {
    // 需要进行xsrf防护的模块
    module: []
  },

  // session配置
  session: {
  }
}, serverConfig)
