BP.directive('readyOn', function ($parse, $timeout) {
	return {
		restrict: 'A',
		link: function (scope, element, attrs) {
			$timeout(function () {
				var fn = $parse(attrs.readyOn);
				fn(scope, {
					$event: event
				});
			});
		}
	};

	// function(scope, element, attrs) {
	// 	var fn = $parse(attrs.readyOn);
	// 	fn(scope, {
	// 		$event: event
	// 	});
	// };
});

BP.directive('getFocus', function ($timeout) {
	return {
		restrict: 'A',
		link: function (scope, element, attr) {
			$timeout(function () {
				$(element).focus();
				$(element).select();
			});
		}
	};
});
BP.directive('ngRightClick', function ($parse) {
	return function (scope, element, attrs) {
		var fn = $parse(attrs.ngRightClick);
		element.bind('contextmenu', function (event) {
			scope.$apply(function () {
				event.preventDefault();
				fn(scope, {
					$event: event
				});
			});
		});
	};
});