'use strict';
var mongoose = require('mongoose');
var Schema = mongoose.Schema;

// model名称，即表名
exports.model = 'Endecode';

// 表结构
exports.schema = [{
  key: { type: String, unique: true, required: true },
  file_name: { type: String, unique: false, required: false },
  command: { type: String, unique: false, required: false },
  desc: { type: String, unique: false, required: false }
}, {
  // autoIndex: true,
  versionKey: false
}];

// 静态方法:http://mongoosejs.com/docs/guide.html#statics
exports.statics = {}
var reg = /^[\u4E00-\u9FA5]+$/;
// http://mongoosejs.com/docs/guide.html#methods
exports.methods = {
  saveByKey: async function () {
    if (reg.test(this.key)) return false;
    return this.save();
  },
  query: async function () {
    return this.model("Endecode").find()
  },
  delete: async function (_id) {
    return await this.model("Endecode").remove({ "_id": _id });
    
  },
  update: async function (_id, obj) {
    return await this.model("Endecode").update({ "_id": _id }, obj)
  }
}