import os.path
import posix

from feature import *
from feature.publicFun import devResult
def getUserids(uuid):
    sql=finance_uuid_idno_userids_sql.format(uuid)
    useris_df=execmysl('feature_aliyun',sql)
    if useris_df.empty:
        return custom_enum_info.custom_not_exist
    return useris_df['user_id'].to_list()

def vcc_fixed_amount(uuid,userids,type='fixed'):
    #VCC现有固定额度
    try:
        #print("uuid[{}]的userids:".format(uuid),userids)
        temp_user_id="("+str(userids[0])+")" if len(userids)==1 else tuple(userids)
        vcc_fixed_amount_change_sql=vcc_fixed_amount_sql.format(temp_user_id).strip()
        df=execmysl('feature_aliyun',vcc_fixed_amount_change_sql)

        #print(df)
        if df.empty:
            return custom_enum_info.custom_not_exist
        elif type=='fixed':
            df=df.fillna(-1)
            temp= sum(df['fixed_amount'].to_list())
            #print('**'*100,temp)
            return temp if temp>0 else custom_enum_info.custom_not_exist
        elif type=='used':
            df=df.fillna(-1)
            temp= sum(df['used_amount'].to_list())

            return temp
        else:
            print("type[]不支持".format(type))
            return 1/0

    except:
        traceback.print_exc(3)
        return custom_enum_info.custom_error

def vcc_temporary_amount(uuid,userids):
    #VCC现有临时额度
    try:
        temp_user_id="("+str(userids[0])+")" if len(userids)==1 else tuple(userids)
        vcc_temporary_amount_change_sql=vcc_temporary_amount_sql.format(temp_user_id).strip()
        df=execmysl('feature_aliyun',vcc_temporary_amount_change_sql)

        if df.empty:
            return custom_enum_info.custom_not_exist
        df=df.fillna(-1)
        temp= sum(df['amount'].to_list())
        return temp if temp>0 else custom_enum_info.custom_not_exist
    except:
        traceback.print_exc(3)
        return custom_enum_info.custom_error

def vcc_sum_amount(uuid,userids):
    #VCC现有总额度
    a1=vcc_fixed_amount(uuid,userids)
    a1_temp=a1 if a1>0 else 0
    a2=vcc_temporary_amount(uuid,userids)
    a2_temp=a2 if a2>0 else 0
    #print('ttt',a1_temp,a2_temp)
    return a1_temp+a2_temp if a2_temp or a1_temp else custom_enum_info.custom_not_exist

def vcc_used_amount(uuid,userids):
    #VCC已用额度
    a1=vcc_fixed_amount(uuid,userids,type='used')
    return round(a1,2)

def cash_used_amount(uuid,userids):
    #现金分期当前在贷
    try:
        #userids=getUserids(uuid)
        temp_user_id="("+str(userids[0])+")" if len(userids)==1 else tuple(userids)
        cash_used_amount_change_sql=cash_used_amount_sql.format(temp_user_id).strip()
        df=execmysl('feature_aliyun',cash_used_amount_change_sql)
        if df.empty:
            return custom_enum_info.custom_not_exist
        df=df.fillna(-1)
        temp= sum(df['required_repayment'].to_list())
        return temp if temp>0 else custom_enum_info.custom_not_exist
    except:
        traceback.print_exc(3)
        return custom_enum_info.custom_error


def vcc_credit_usage(uuid,userids):
    #现金分期当前在贷
    a1=vcc_used_amount(uuid,userids)
    a1_temp=a1 if a1>0 else 0
    a2=vcc_sum_amount(uuid,userids)
    a2_temp=a2 if a2>0 else 0
    try:
        return round(a1_temp/a2_temp,2)
    except:
        traceback.print_exc(3)
        return custom_enum_info.custom_not_exist

def simple_exec(uuid,codes):
    #codes=['vcc_fixed_amount','vcc_temporary_amount','vcc_sum_amount','vcc_used_amount','cash_used_amount','vcc_credit_usage']
    #codes=['vcc_sum_amount']
    userids=getUserids(uuid)
    #print(userids)
    temp={}
    temp['uuid']=uuid
    for i in codes:
        temp[i+'_test']=eval("{}(uuid,userids)".format(i))
        #print('@@'*100,temp[i+'_test'])
    return temp

def main(codes):
    try:
        result_dev=[]
        result_test=[]
        filename=os.path.join(feature_report,'uuids.xlsx')
        uuids_df=readFile(filename)
        uuids=uuids_df['uuid'].to_list()
        for uuid in uuids:
            print("执行的uuid,",uuid)
            result1=devResult(uuid,codes,codetype='pre')
            result_dev.append(result1)
            result2=simple_exec(uuid,codes)
            result_test.append(result2)
            #return 0
        dev_df=pd.DataFrame(result_dev)
        test_df=pd.DataFrame(result_test)
        #to_excel(filename,index=0,encoding = 'utf-8',float_format = str)
        dev_df.to_excel(os.path.join(feature_report,'dev.xlsx'),index=0,encoding = 'utf-8')
        test_df.to_excel(os.path.join(feature_report,'test.xlsx'),index=0,encoding = 'utf-8')
        print("测试完成")
    except:
        traceback.print_exc(3)

def data_to_write(uuids,kwargs):
    result=[]
    for uuid in uuids:
        print("执行的uuid,",uuid)
        #print("data_to_write:",kwargs)
        result1=devResult(uuid,codes=kwargs.get('codes'),codetype=kwargs.get('codetype'))
        result.append(result1)
    #print("result--",result)
    return result


def exec_to_write(uuids,kwargs):
    result=[]
    for uuid in uuids:
        print("执行的uuid,",uuid)
        result2=simple_exec(uuid,codes)
        result.append(result2)
    return result

def main_final(codes,threadnum=3):
    codetype='pre'
    final_result=[]
    my_threads=[]
    filename=os.path.join(feature_report,'uuids.xlsx')
    uuids_df=readFile(filename)
    uuids=uuids_df['uuid'].to_list()[:10]
    #divnum=int(len(uuids)/threadnum)
    divlists=split_by_num(uuids,threadnum)
    print(divlists)
    #print("divlists:",divlists)
    temp={
        "codes":codes,
        "codetype":'pre'
    }
    for i in range(threadnum):
        mythreads=MyThread(exec_to_write,divlists[i],**temp)
        my_threads.append(mythreads)
        mythreads.start()
    for i in my_threads:
        i.join()
    for i in my_threads:
        final_result+=i.get_result()
    return final_result



def compare(codes):
    dev_df=readFile("dev.xlsx")
    test_df=readFile("test.xlsx")
    df=dev_df.merge(test_df,on='uuid', how='inner')
    print(df.head(2))
    for code in codes:
        df[code+"_result"]=df[code+'_dev']==df[code+"_test"]

    df.to_excel(os.path.join(feature_report,'result.xlsx'),index=0,encoding = 'utf-8')




if __name__ == '__main__':
    codes=['vcc_fixed_amount','vcc_temporary_amount','vcc_sum_amount','vcc_used_amount','cash_used_amount','vcc_credit_usage']
    #compare(codes)
    codes=['vcc_used_amount','vcc_temporary_amount']
    #t=simple_exec('9d287da7-c5e8-4319-bd8f-b81abb8b294d',codes)
    #print(t)
    print('over==',main_final(codes))