from recommend import *
from recommend.publicFunc import *
def step1():
    '''
    :return: 触发文本搜索
    '''
    res=sendsearch(isFirstPage=1)
    top10_sku=res[0].get('skunos').split(',')[:10]
    # print(top10_sku)
    return top10_sku,res

def getseed(top10_sku):
    '''
    :param top10_sku:
    :return: 根据top10的skus，获取cid3种子，brand_name种子,平均价格
    '''
    result={}
    #top10_sku=['37993180305409', '37993297751553', '37993171924993', '275043759168001', '37993633292801', '37993473904641', '37993926891009', '37993482297345', '10982072256513', '37993239032321']
    result['sku_nos']=top10_sku
    sql=concatSql(skuinfo_sql,**{'sku_no':top10_sku})
    print(sql)
    df=execmysl(89,sql)
    df['cid3']=df['cid3'].astype('string')
    df['brand_id']=df['brand_id'].astype('string')
    cid3=df.groupby(by=['cid3']).groups.__repr__()#['cid3']#.max()
    brandname=df.groupby(by=['brand_name']).groups.__repr__()
    brandid=df.groupby(by=['brand_id']).groups.__repr__()
    # print('--',brandid,type(brandid))
    # print('--',brandname,type(brandid))
    result['cid3']=maxdict(**json.loads(cid3.replace("'",'"')))
    result['brand_name']=maxdict(**json.loads(brandname.replace("'",'"')))
    result['brand_id']=maxdict(**json.loads(brandid.replace("'",'"')))
    result['avg_price']=df['price'].mean()
    result['skuinfo']=df.to_dict(orient='records')
    return result

def similarskus(top10_sku):
    '''
    :param top10_sku:
    :return: top10的相似数据
    '''
    rediskeys=[similar_redis.format(skuno=i) for i in top10_sku]
    result=defaultdict(list)
    temp=dict(zip(top10_sku,rediskeys))
    for k,v in temp.items():
        temp[k]=getRedisValue(v)
    return temp

def seedSkus(top10_sku):
    '''
    :param top10_sku:
    :return: 当每个商品的都没有相似数据时，则需要找每个商品同brandname｜cid3，价格差最小的top10
    '''
    seeddata=getseed(top10_sku)
    temp=[]
    for ssku in seeddata.get('skuinfo'):
        sku=minPriceFill(ssku,10)
        temp+=sku
        print("商品[{}]价格差最小的补足数据".format(ssku),sku)
    return temp








if __name__ == '__main__':
    # top10_sku=[1,2,3,4]
    # print(similarskus(top10_sku))
    # aa={}
    # skus={'skuinfo': [{'id': 13573, 'sku_no': '10982072256513', 'price': 139.9,'cid1': 1320, 'cid2': 1583, 'cid3': '1592', 'brand_name': '蜀道香','brand_id': 'nan', 'source_type': 6},
    #                   {'id': 229065184, 'sku_no': '275043759168001', 'price': 25.0, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '口水娃','brand_id': 'nan', 'source_type': 1},
    #                   {'id': 154060057, 'sku_no': '37993171924993', 'price': 39.9, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2},
    #                   {'id': 154058134, 'sku_no': '37993180305409', 'price': 36.0, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2},
    #                   {'id': 55340, 'sku_no': '37993239032321', 'price': 21.9, 'cid1': 1320, 'cid2': 1583,'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2},
    #                   {'id': 534359815, 'sku_no': '37993297751553', 'price': 69.9, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '盐津铺子', 'brand_id': 2574.0, 'source_type': 2},
    #                   {'id': 337773081, 'sku_no': '37993473904641', 'price': 35.9, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2},
    #                   {'id': 154060077, 'sku_no': '37993633292801', 'price': 13.9, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2},
    #                   {'id': 56569, 'sku_no': '37993926891009', 'price': 19.0, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2}]}
    # print('最终结果：',seedSkus(skus))
    top10_sku=['327855415236097', ' 323546673847809', ' 266105822909441', ' 437347360180225', '265358221515265', '265347593669633', '46676152944641', '294644949195265', '256787949822465', '277221256729601']
    print(getseed(top10_sku))