import pandas as pd
from sqlalchemy import create_engine
from collections import  defaultdict
from urllib import parse

REDIS_CONFIG = {
    'REDIS_NODES': [
        {'host': '172.24.17.119', 'port': 6371},
        {'host': '172.24.17.119', 'port': 6372},
        {'host': '172.24.17.119', 'port': 6373},
        {'host': '172.24.17.119', 'port': 6374},
        {'host': '172.24.17.119', 'port': 6375},
        {'host': '172.24.17.119', 'port': 6376}
    ],
    'REDIS_EXPIRE_TIME': 26 * 3600,
    'REDIS_MAX_CONNECTIONS': 50,
    'REDIS_PASSWD': 'redis',
}

dapan_redis_config={
    'REDIS_NODES': [
        {'host': '172.29.2.5', 'port': 6371},
        {'host': '172.29.2.5', 'port': 6372},
        {'host': '172.29.2.5', 'port': 6373}
    ],
    'REDIS_EXPIRE_TIME': 26 * 3600,
    'REDIS_MAX_CONNECTIONS': 50,
    'REDIS_PASSWD': '1234',
}

from rediscluster import RedisCluster


redis_db_conn_119 = RedisCluster(startup_nodes=REDIS_CONFIG.get('REDIS_NODES'),
                                 max_connections=REDIS_CONFIG.get('REDIS_MAX_CONNECTIONS'),
                                 password=REDIS_CONFIG.get('REDIS_PASSWD'), decode_responses=True)

# dapan_redis_db_conn = RedisCluster(startup_nodes=dapan_redis_config.get('REDIS_NODES'),
#                                       max_connections=dapan_redis_config.get('REDIS_MAX_CONNECTIONS'),
#                                       password=dapan_redis_config.get('REDIS_PASSWD'),
#                                        decode_responses=True,
#                                        skip_full_coverage_check=True)
def getRedisValue(key,conntype=None,oper='select'):
    '''
    :param key:
    :param conntype: 区分不同的redis连接
    :param oper:如果是delete，则做删除操作。目前只支持delete，select
    :return:select->获取所有匹配到key的值
    '''
    if 'select' in key or 'from' in key:
        raise Exception('在redis看来不是有效的key',key)
    redis_value = defaultdict()
    if conntype == 'dapan':
        redis_db_conn=dapan_redis_db_conn
    else:
        redis_db_conn=redis_db_conn_119
    uuid_redis_result=redis_db_conn.keys(key)
    print('模糊匹配到的所有key:',uuid_redis_result)
    if uuid_redis_result and oper=='delete':
        for i in uuid_redis_result:
            redis_db_conn.delete(i)
        return 'delete succ'
    #print(uuid_redis_result)
    if not uuid_redis_result:
        print("[{key}]模糊没有匹配到数据，返回0".format(key=key))
        return 0
    #print(uuid_redis_result,key,redis_key_type)
    for i in uuid_redis_result:
        redis_key_type=redis_db_conn.type(i)
        if redis_key_type == 'list':
            redis_value[i]=redis_db_conn.lrange(i,0,100)
            # uuid_redis_result = redis_db_conn.lrange(i)
        elif redis_key_type in ('dict','hash'):
            redis_value[i]=redis_db_conn.hgetall(i)
            for k,v in redis_value[i].items():
                print('redis key[{}]'.format(i),"===>",k,'===>',v)
            # uuid_redis_result = redis_db_conn.hgetall(i)
        elif redis_key_type=='string':
            #print(i)
            #print(redis_db_conn.get('search_online_feature:243717827731969_sku'))
            redis_value[i]=redis_db_conn.get(i)

    return redis_value

if __name__ == '__main__':
    userUuid='00003a93-2a32-4501-b338-755b6cb1ec49'
    t=getRedisValue("search_fm_offline_feature:cd11201d3e789c63_query_offline")
    print(t)

    ## search_fm_offline_feature:{md5(搜索词)}_query_offline
    ## 内部：md5加密


