from recommend import *
def dapanFill(num=300):
    '''
    :param num: 从大盘取多少条数据
    :return:
    '''
    temp=defaultdict()
    df=execmysl(119,dapan_sql)
    temp['recall_reason']='大盘补足'
    temp['skus']=df['sku_no'].to_list()[:num]
    return temp

def minPriceFill(skus,num=100):
    '''
    :param skus: dict,要包括：cid3，brand_name eg:{'id': 154060057, 'sku_no': '37993171924993', 'price': 39.9, 'cid1': 1320, 'cid2': 1583, 'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2}
    :return:
    '''
    temp=[]
    concat_cid3_sql=concatSql(skuinfo_sql,**{"cid3":skus.get('cid3')})
    concat_brandname_sql=concatSql(skuinfo_sql,**{"brand_name":skus.get('brand_name')})
    sku_price=float(skus.get('price'))
    brandname_df=execmysl(119,concat_brandname_sql)
    brandname_df['price']=brandname_df['price'].astype('float')
    brandname_df['diff_price']=abs(brandname_df['price']-sku_price)
    brandname_min_price_sku=brandname_df.sort_values(by=['diff_price'])[['sku_no','diff_price','price']]#.to_list()[:num]
    print("同品牌[{}]价格差最小的商品信息".format(skus.get('brand_name')),brandname_min_price_sku)
    temp+=brandname_min_price_sku['sku_no'].to_list()[:num]
    if len(temp)<num:
        cid3_df=execmysl(119,concat_cid3_sql)
        cid3_df['price']=cid3_df['price'].astype('float')
        #t=cid3_df[cid3_df['sku_no']=='361165411589122']#['price']
        if cid3_df.empty:
            return temp
        cid3_df['diff_price']=abs(cid3_df['price']-sku_price)
        cid3_min_price_sku=cid3_df.sort_values(by=['diff_price'])[['sku_no','diff_price','price']]#.to_list()[:num]
        print("同cid3[{}]价格差最小的商品信息".format(skus.get('cid3')),
              cid3_min_price_sku)
        temp+=cid3_min_price_sku['sku_no'].to_list()
    return temp[:num]


def skuinfo(sku):
    change_sql=concatSql(skuinfo_sql,**{"sku_no":sku})
    sku_df=execmysl(119,change_sql)
    sku_info=sku_df[['cid1','cid2','cid3','brand_name']].to_dict(orient='records')[0]
    return sku_info


def normalClickTopic(sku_no,change_sql):
    sku_info=skuinfo(sku_no)
    # cids=[]
    # print(sku_info)
    # cids.append(sku_info.get('cid1'))
    # cids.append(sku_info.get('cid2'))
    # cids.append(sku_info.get('cid3'))
    # change_sql=concatSql(jd_hot_sql,**{"category_id":cids})
    hot_df=execmysl(119,change_sql)
    final_result=[]
    if 'category_level' in change_sql:
        cid3_condition="hot_df['category_level']==3"
        cid2_condition="hot_df['category_level']==2"
        cid1_condition="hot_df['category_level']==1"
        no_cid123_condition="hot_df['category_id']==-1"
    else:
        cid3_condition="hot_df['cid3']==sku_info.get('cid3')"
        cid2_condition="hot_df['cid3']==sku_info.get('cid2')"
        cid1_condition="hot_df['cid3']==sku_info.get('cid1')"
        no_cid123_condition="hot_df['cid3']==-1"

    condition1=hot_df[eval(cid3_condition) & (hot_df['brand_name']==sku_info.get('brand_name'))] \
        .sort_values(ascending=False,by='final_score')
    final_result+=condition1['jg_id'].to_list()
    print('condition1:',final_result)
    if len(set(final_result))<30:
        condition2=hot_df[eval(cid2_condition) & (hot_df['brand_name']==sku_info.get('brand_name'))] \
            .sort_values(ascending=False,by='final_score')
        final_result+=condition2['jg_id'].to_list()
    print('condition2:',final_result)
    if len(set(final_result))<30:
        condition3=hot_df[eval(cid1_condition) & (hot_df['brand_name']==sku_info.get('brand_name'))] \
            .sort_values(ascending=False,by='final_score')

        final_result+=condition3['jg_id'].to_list()
    print('condition3:',final_result)
    if len(set(final_result))<30:
        condition4=hot_df[eval(cid3_condition)& (hot_df['brand_name']=='no_brand_name') ] \
            .sort_values(ascending=False,by='final_score')

        final_result+=condition4['jg_id'].to_list()
    print('condition4:',final_result)
    if len(set(final_result))<30:
        condition5=hot_df[eval(cid2_condition)& (hot_df['brand_name']=='no_brand_name') ] \
            .sort_values(ascending=False,by='final_score')

        final_result+=condition5['jg_id'].to_list()
    print('condition5:',final_result)
    if len(set(final_result))<30:
        condition6=hot_df[eval(cid1_condition) & (hot_df['brand_name']=='no_brand_name') ] \
            .sort_values(ascending=False,by='final_score')

        final_result+=condition6['jg_id'].to_list()
    print('condition6:',final_result)
    if len(set(final_result))<30:
        condition7=hot_df[(hot_df['brand_name']==sku_info.get('brand_name')) & eval(no_cid123_condition) ] \
            .sort_values(ascending=False,by='final_score')
        final_result+=condition7['jg_id'].to_list()
    print('condition7:',final_result)
    if len(set(final_result))<30:
        final_result+=jgDapanBu()
    #print(final_result)
    final_result_temp=list(set(final_result))
    final_result_temp.sort(key=final_result.index)
    print('去重结果：',len(final_result_temp),final_result_temp)
    return final_result_temp[:30]


def normalSearchTopic(conditions,df):
    result=[]
    # seed_cid3=seed_data['cid3']
    # cid2=seed_data['cid2']
    # cid1=seed_data['cid1']
    # seed_brandname=seed_data['brand_name']
    #df=execmysl(119,sql)
    for k in conditions:
        condition1=df[eval(k['condition'])].sort_values(by=[k['by']],ascending=False)['jg_id'].to_list()
        result+=condition1
        if len(set(result))>30:
            break
    return result

def concatCondition(seedData,contype='jg'):
    if contype=='jg':
        condition1="(df['cid3']=={})".format(seedData['cid3']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])
        condition2="(df['cid2']=={})".format(seedData['cid2']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])
        condition3="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])
        condition4="(df['cid3']=={})".format(seedData['cid3']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')
        condition5="(df['cid2']=={})".format(seedData['cid2']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')
        condition6="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')
        condition7="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])
        conditions=[]
        conditions.append({'condition':condition1,'by':'score_cid3'})
        conditions.append({'condition':condition2,'by':'score_cid2'})
        conditions.append({'condition':condition3,'by':'score_cid1'})
        conditions.append({'condition':condition4,'by':'score_cid3'})
        conditions.append({'condition':condition5,'by':'score_cid2'})
        conditions.append({'condition':condition6,'by':'score_cid1'})
        conditions.append({'condition':condition7,'by':'score_brand'})
        return conditions
    elif contype=='cid':
        condition1="(df['cid3']=={})".format(seedData['cid3']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'] + \
                        "&" +"(df['jg_type']==1)"
                                                          )
        condition2="(df['cid2']=={})".format(seedData['cid2']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])+"&" +"(df['jg_type']==1)"
        condition3="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])+"&" +"(df['jg_type']==1)"
        condition4="(df['cid3']=={})".format(seedData['cid3']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')+"&" +"(df['jg_type']==1)"
        condition5="(df['cid2']=={})".format(seedData['cid2']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')+"&" +"(df['jg_type']==1)"
        condition6="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')+"&" +"(df['jg_type']==1)"
        condition7="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])+"&" +"(df['jg_type']==1)"
        conditions=[]
        conditions.append({'condition':condition1,'by':'score_cid3'})
        conditions.append({'condition':condition2,'by':'score_cid2'})
        conditions.append({'condition':condition3,'by':'score_cid1'})
        conditions.append({'condition':condition4,'by':'score_cid3'})
        conditions.append({'condition':condition5,'by':'score_cid2'})
        conditions.append({'condition':condition6,'by':'score_cid1'})
        conditions.append({'condition':condition7,'by':'score_brand'})
        return conditions
    elif contype=='brandname':
        condition1="(df['cid3']=={})".format(seedData['cid3']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'] + \
                                                          "&" +"(df['jg_type']==2)"
                                                          )
        condition2="(df['cid2']=={})".format(seedData['cid2']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])+"&" +"(df['jg_type']==2)"
        condition3="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])+"&" +"(df['jg_type']==2)"
        condition4="(df['cid3']=={})".format(seedData['cid3']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')+"&" +"(df['jg_type']==2)"
        condition5="(df['cid2']=={})".format(seedData['cid2']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')+"&" +"(df['jg_type']==2)"
        condition6="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format('no_brand_name')+"&" +"(df['jg_type']==2)"
        condition7="(df['cid1']=={})".format(seedData['cid1']) + \
                   "&" +"(df['brand_name']=='{}')".format(seedData['brand_name'])+"&" +"(df['jg_type']==2)"
        conditions=[]
        conditions.append({'condition':condition1,'by':'score_cid3'})
        conditions.append({'condition':condition2,'by':'score_cid2'})
        conditions.append({'condition':condition3,'by':'score_cid1'})
        conditions.append({'condition':condition4,'by':'score_cid3'})
        conditions.append({'condition':condition5,'by':'score_cid2'})
        conditions.append({'condition':condition6,'by':'score_cid1'})
        conditions.append({'condition':condition7,'by':'score_brand'})
        return conditions

def dapanBu():
    '''
    :return: 获取当前大盘批次，然后拼接redis，拿到大盘数据
    '''
    cur_dapan_redis="same_product_batch_uuid"
    batch=getRedisValue(cur_dapan_redis).get(cur_dapan_redis)
    dapan_redis=cur_dapan_redis+":"+str(batch)
    return getRedisValue(dapan_redis).get(dapan_redis)


def jgDapanBu():
    df=execmysl(119,jg_dapan_sql)
    print(df['jg_id'])
    return df['jg_id'].to_list()


def cidinfo(**kwargs):
    sql="""
    select distinct c_id1,c_id2,c_id3,brand_name from kdsp.t_sku_info where  status=3 and tenant_id=560761 and c_id3={}
    """.format(kwargs.get('cid3'))
    df=execmysl('test1',sql)
    return df

if __name__ == '__main__':
    skus={'id': 154060057, 'sku_no': '37993171924993', 'price': 39.9, 'cid1': 1320, 'cid2': 1583,
          'cid3': '1590', 'brand_name': '口水娃', 'brand_id': 10590.0, 'source_type': 2}

    #print(minPriceFill(skus))
    # sku_no='5187546'
    # sku_info=skuinfo(sku_no)
    # cids=[]
    # print(sku_info)
    # cids.append(sku_info.get('cid1'))
    # cids.append(sku_info.get('cid2'))
    # cids.append(sku_info.get('cid3'))
    # change_sql=concatSql(jd_hot_sql,**{"category_id":cids})
    # #change_sql=concatSql(jd_hot_sql,)
    # t=normalClickTopic(sku_no,change_sql)
    # print(t)
    print(dapanBu())





