import os.path

from databaseConn import *
import pandas as pd

def genReportName(name=''):
    '''
    :param name:
    :return:生成文件名
    '''
    t=round(datetime.datetime.now().timestamp())
    return name+'_'+str(t)+'.xlsx'

def filePath(filepath,name=''):
    filename=genReportName(name)
    return os.path.join(filepath,filename)

def readFile(filename,sheetname=0):
    '''
    :param filename:
    :return:读取csx或xlsx文件
    '''
    houzhui=filename.split('.')[-1]
    if houzhui=='csv':
        df=pd.read_csv(filename, index_col=0,sheetname=sheetname)
    else:
        df=pd.read_excel(filename,sheet_name=sheetname)
    return df

def deleteFile(filename):
    if os.path.exists(filename):
        os.system('rm {}'.format(filename))
        return 'delete succ'
    return '{} is not found'.format(filename)

def getfirstFileData(file_path,filename=None):
    filename=filename if filename \
        else os.popen("cd {};ls -t |grep -v 'init' |head -1".format(file_path)).read(100)
    filename_path=os.path.join(file_path,filename.strip())
    print('解析文件名：',filename_path)
    return filename_path

def readRenameColums(filename,fcolums,sheetname=0):
    '''
    :param filename:
    :param fcolums:list，重命名的数据
    :return:列名重命名
    '''
    df=readFile(filename,sheetname)
    try:
        df=df.rename(columns=dict(zip(df.columns,fcolums[0:len(df.columns)])))
    except Exception as e:
        print('重命名的列名数[{}]小于文档中的列名数[{}]，导致无法重命名'.format(len(fcolums),len(df.columns)))
        #print('===接口',traceback.print_exc())
        ##获取错误的堆栈信息
        print("异常的堆栈信息:")
        traceback.format_exc(limit=2)
    return df



if __name__ == '__main__':
    filename="/Users/dm/Downloads/量化派/特征/百行贷前特征code(1).xlsx"
    df=readFile(filename)
    print(df['指标英文'].to_list())

