import os
import random
import pandas as pd
from search import *
def requestsend(uuid,deviceid,searchContent,selectedActivitie,page=1,searchtype='txt',env='test'):
    """
    :param uuid: 用户uuid
    :param deviceid: 设备号id
    :param searchContent: 文本搜索
    :param page: 默认1，搜索页
    :param selectedActivitie: 专题id
    :param type: txt表示文本搜索，否则为专题搜索
    :param env: 环境
    :return:
    """
    if env not in ['test','pro','online']:
        raise Exception('env[{}]只能:test|pro'.format(env))
    if env=='online':
        baseurl="http://caesar-gateway.q-gp.com"
    elif env=="test":
        #baseurl="http://172.16.9.90:8091"
        baseurl="https://caesar-gateway-bd.liangkebang.net"
    else:
        baseurl="http://open-search-engine.ec-{env}.qg-rc.net".format(env=env) if env=='test' \
            else "http://open-search-engine.qg-{env}.qgwebservice.com".format(env=env)
    url=baseurl+"/search"
    header = {
        "XQG-USER-UUID": uuid,
        "content-type": "application/json",
        "XQG-DEVICE-ID": deviceid
    }
    body = {
        "channel": random.sample(channel, 1)[0],
        "userUuid": uuid,
        "deviceId": deviceid,
        "extraParams": {
            "appVersion": "8.7.00",
            "terminal": "ios"
        },
        ##文本搜索
        # "searchContent":searchContent ,
        ##专题搜索
        # "selectedActivities":[{
        #     "id": ''.join(random.sample([str(i) for i in range(40)],1)),
        #     "type":2
        # }],
        "flipInfo": {
            "pageNo": page,
            "pageSize": 20
        }
    }
    if searchtype == 'txt': ##文本
        body['searchContent'] = searchContent
    elif searchtype == 'label': ##
        body['selectedActivities'] = [{
            "id": selectedActivitie,  # ''.join(random.sample(','.join('215,214,34,33,32,31,30'),1)),
            "type": 2
        }]
    elif searchtype == 'capt':
        body['selectedActivities'] = [{
            "id": selectedActivitie,  # ''.join(random.sample(','.join('215,214,34,33,32,31,30'),1)),
            "type": 3
        }]
    elif searchtype == 'activity':
        body['selectedActivities'] = [{
            "id": selectedActivitie,  # ''.join(random.sample(','.join('215,214,34,33,32,31,30'),1)),
            "type": 1
        }]
    t = requests.post(url, json=body, headers=header)
    print('搜索词:',searchContent)
    try:
        spu_nos = jsonpath.jsonpath(t.json(), '$..skuNo') or ['null']
        sku_names = jsonpath.jsonpath(t.json(), '$..skuName') or ['null']
        page_size = jsonpath.jsonpath(t.json(), '$..totalPage')[0]
        search_id = jsonpath.jsonpath(t.json(), '$..searchId')[0]
        total_skus=jsonpath.jsonpath(t.json(), '$..totalCount')[0]
        cid3s=jsonpath.jsonpath(t.json(), '$..cid3') or ['null']
        brandnames=jsonpath.jsonpath(t.json(), '$..brandId') or ['null']
        request_time = t.elapsed.total_seconds()
        tttt=','.join(spu_nos)
        #print(tttt,type(tttt))
        # with open('sku_result_3.txt', 'a+') as file:
        #     file.write('搜索词:' + searchContent + ";result:" + ','.join(sku_names) + "\n")
        return page_size, ','.join(spu_nos), str(request_time), search_id,','.join(sku_names),searchContent,\
               total_skus,cid3s,brandnames
    except:
        print('搜索接口报错:',searchContent,t.text)


def hotWord(filename,sheetname=0):
    from tools.fileOperation import readRenameColums
    filepath=os.path.join(data_file_path,filename)
    df=readRenameColums(filepath,fcolums=['search_words'],sheetname=sheetname)
    return df

def totalrun(selectedActivitie=1, type='txt', num=0,isFirstPage=False,sheetname=0,ishotwordrand=1):
    '''
    :param selectedActivitie: 选填
    :param type: 跑文本搜索，还是专题搜索。目前支持：'txt'｜'label'｜'capt'｜'activity'
    :param num: 和ishotwordrand组合，如果ishotwordrand=1，则随机获取搜索词；如果为0，则按照顺序获取搜索词
    :param isFirstPage: 如果只跑第一页，则需要设置为true
    :param sheetname:获取搜索词的sheetname，默认0，第一个工作薄
    :return:
    '''
    timenow=time.strftime('%Y-%m-%d %H:%M:%S', time.localtime())
    temp=[]
    result_temp={}
    searchContents=hotWord('线上环境搜索热词.xlsx',sheetname=sheetname)['search_words'].apply(lambda x:str(x).strip()).to_list()
    if ishotwordrand:
        random_value=random.Random().randint(0,len(searchContents)-1)
    else:
        random_value=num
    from tools.publicFun import genUuidDeviceid
    uuid,deviceid=genUuidDeviceid()
    selectedActivitie='2'
    flag=1
    try:
        page_size, spu_nos, \
        request_time, search_id,sku_names,searchContent,total_skus,*info=\
            requestsend(uuid,deviceid,searchContents[random_value],selectedActivitie,flag,type)
        result_temp["nowtime"]=str(timenow)
        result_temp["deviceid"]=deviceid
        result_temp["uuid"]=uuid
        result_temp["searchcontent"]=searchContent
        result_temp["pageno"]=flag
        result_temp["costtime"]=request_time
        result_temp["skunos"]=spu_nos
        result_temp['totalSkus']=total_skus
        temp.append(result_temp)
        file_template=["nowtime","searchcontent","pageno","costtime","deviceid","uuid","skunos"]
        flag+=1
        while  flag<=page_size and not isFirstPage:
            result_temp={}
            page_size, spu_nos, \
            request_time, search_id,sku_names,searchContent,total_skus,*info= \
                requestsend(uuid,deviceid,searchContents[random_value],selectedActivitie,flag,type)
            result_temp["nowtime"]=timenow
            result_temp["searchcontent"]=searchContent
            result_temp["pageno"]=flag
            result_temp["costtime"]=request_time
            result_temp["deviceid"]=deviceid
            result_temp["uuid"]=uuid
            result_temp["skunos"]=spu_nos
            result_temp['totalSkus']=total_skus
            temp.append(result_temp)
            flag+=1
    #filename=genReportName('searchResult')
        print(temp)
        return temp
    except:
        traceback.print_exc(limit=2)


def allRun(num,isFirstPage=0,sheetname=0,ishotwordrand=1):
    ttemp=[]
    for i in range(num):
        print('第[{}]次搜索'.format(str(i)))
        try:
            temp=totalrun(num=i,isFirstPage=isFirstPage,sheetname=sheetname,ishotwordrand=ishotwordrand)
            ttemp+=temp
            #print(temp)
        except:
            traceback.print_exc(limit=2)
    df=pd.DataFrame(ttemp)
    reportname=filePath(file_path,'searchResult')
    #df['skunos']=df['skunos'].astype('string')
    df.to_excel(reportname,index=0,encoding = 'utf-8',float_format = str)



def analysis(filename=None):
    #temp=defaultdict()
    result=[]
    filename=filename if filename \
        else os.popen("cd {};ls -t |grep -v 'init' |head -1".format(file_path)).read(100)
    filename_path=os.path.join(file_path,filename.strip())
    print('解析文件名：',filename_path)
    df=readFile(filename_path)
    df['searchcontent'].fillna('无效',inplace=True)
    mean_costtime=str(round(df['costtime'].mean(),3)*1000)+'ms'
    count_by=['uuid','deviceid','searchcontent']
    uds=df.groupby(count_by)#['skunos']
    #count_by_skus=count_by.append('skunos')
    #df1=pd.DataFrame(spus,columns=count_by_skus)#['skunos']
    for uuid,deviceid,searchcontent in uds.groups:
        temp={}
        temp['uuid']=uuid
        temp['deviceid']=deviceid
        temp['searchcontent']=searchcontent

        tempskus=df[(df['uuid']==uuid) & (df['deviceid']==deviceid) \
                            &(df['searchcontent']==searchcontent)]['skunos'].to_list()#.__str__()
        temp['costtime']=df[(df['uuid']==uuid) & (df['deviceid']==deviceid) \
                            &(df['searchcontent']==searchcontent)]['costtime'].to_list()
        temp['totalSkus']=mergelist([str(i).split(',') for i in tempskus])
        #print(tempskus)

        temp['isrepeat']=0 if len(temp['totalSkus']) == len(list(set(temp['totalSkus']))) else 1

        temp['curpage_countskus']=len(temp['totalSkus'])

        #print(uuid,deviceid,searchcontent)

        #temppp=1
        temp['countskus']=df[(df['uuid']==uuid) & (df['deviceid']==deviceid) \
                             &(df['searchcontent']==searchcontent)]['totalSkus'].to_list()[0]

        result.append(temp)

    startans=pd.DataFrame(result)

    fist_200=startans[(startans['countskus']<=200)]
    fist_500=startans[(startans['countskus']>200) & (startans['countskus']<=500)]
    fist_1000=startans[(startans['countskus']>500) & (startans['countskus']<=1000)]

    fist1_200_1=[i for i in mergelist(fist_200['costtime'].to_list()) if str(i)>='0.1']
    fist1_200_2=[i for i in mergelist(fist_200['costtime'].to_list()) if str(i)>='0.15']
    fist1_200_3=[i for i in mergelist(fist_200['costtime'].to_list()) if str(i)>='0.2']


    fist1_500_1=[i for i in mergelist(fist_500['costtime'].to_list()) if str(i)>='0.1']
    fist1_500_2=[i for i in mergelist(fist_500['costtime'].to_list()) if str(i)>='0.15']
    fist1_500_3=[i for i in mergelist(fist_500['costtime'].to_list()) if str(i)>='0.2']

    fist1_1000_1=[i for i in mergelist(fist_1000['costtime'].to_list()) if str(i)>='0.1']
    fist1_1000_2=[i for i in mergelist(fist_1000['costtime'].to_list()) if str(i)>='0.15']
    fist1_1000_3=[i for i in mergelist(fist_1000['costtime'].to_list()) if str(i)>='0.2']

    print('总请求数:',startans.shape[0],';平均耗时:',mean_costtime)
    print("spu是否有重复数据:",1 if startans[startans['isrepeat']==1].shape[0] else 0)
    print("搜索词spus总数<=200时-->",'耗时大于100ms的总数',len(fist1_200_1),\
          ';耗时大于150ms的总数',len(fist1_200_2),
          ';耗时大于200ms的总数',len(fist1_200_3))

    print("搜索词spus总数<=500&>200时-->",'耗时大于100ms的总数',len(fist1_500_1), \
          ';耗时大于150ms的总数',len(fist1_500_2),
          ';耗时大于200ms的总数',len(fist1_500_3))

    print("搜索词spus总数<=1000&>500时-->",'耗时大于100ms的总数',len(fist1_1000_1), \
          ';耗时大于150ms的总数',len(fist1_1000_2),
          ';耗时大于200ms的总数',len(fist1_1000_3))

if __name__ == '__main__':
    # t=hotWord('线上环境搜索热词.xlsx')['search_words'].apply(lambda x:str(x).strip())
    # print(t)
    #print(totalrun(isFirstPage=1))
    isexec=1
    ishotwordrand=0
    if isexec:
        allRun(200,isFirstPage=1,sheetname=0,ishotwordrand=ishotwordrand)
    else:
        print(analysis())
    # a=[['236473224274432', '7188063'],['236473224274432', '7188063']]
    # print(list(itertools.chain.from_iterable(a)))






