import pandas as pd
from sqlalchemy import create_engine
from collections import  defaultdict
from urllib import parse

REDIS_CONFIG = {
    "119":{
    'REDIS_NODES': [
        {'host': '172.24.17.119', 'port': 6371},
        {'host': '172.24.17.119', 'port': 6372},
        {'host': '172.24.17.119', 'port': 6373},
        {'host': '172.24.17.119', 'port': 6374},
        {'host': '172.24.17.119', 'port': 6375},
        {'host': '172.24.17.119', 'port': 6376}
    ],
    'REDIS_EXPIRE_TIME': 26 * 3600,
    'REDIS_MAX_CONNECTIONS': 50,
    'REDIS_PASSWD': 'redis',
},"89":{
        'REDIS_NODES': [
            {'host': '172.16.9.89', 'port': 6371},
            {'host': '172.16.9.89', 'port': 6372},
            {'host': '172.16.9.89', 'port': 6373},
            {'host': '172.16.9.90', 'port': 6374},
            {'host': '172.16.9.90', 'port': 6375},
            {'host': '172.16.9.90', 'port': 6376}
        ],
        'REDIS_EXPIRE_TIME': 6000,
        'REDIS_MAX_CONNECTIONS': 10,
        'REDIS_PASSWD':None

    }

}

dapan_redis_config={
    'REDIS_NODES': [
        {'host': '172.29.2.5', 'port': 6371},
        {'host': '172.29.2.5', 'port': 6372},
        {'host': '172.29.2.5', 'port': 6373}
    ],
    'REDIS_EXPIRE_TIME': 26 * 3600,
    'REDIS_MAX_CONNECTIONS': 50,
    'REDIS_PASSWD': '1234',
}
from rediscluster import RedisCluster
import redis
def get_simple_redis_instance(namespace):
    #reids_universal="reids://{name}:{pwd}@{host}:{port}"
    from databaseConn.mysqlOperation import mysqlInfo
    redis_info=mysqlInfo(namespace,dbtype='redis')
    print('redis==',redis_info)
    pool = redis.ConnectionPool(host=redis_info.get('host'), port=redis_info.get('port'),decode_responses=True)
    redis_instance = redis.Redis(connection_pool=pool)
    return redis_instance

def redis_conn(key=None,namespace=None):
    '''
    如果不是从集群的redis配置拿到host等信息，则使用非集群reids创建实例
    :param key:
    :param namespace:
    :return:
    '''
    REDIS_CONFIG_temp=REDIS_CONFIG.get(key)
    if not REDIS_CONFIG_temp:
        return get_simple_redis_instance(key)
    return RedisCluster(startup_nodes=REDIS_CONFIG_temp.get('REDIS_NODES'),
                 max_connections=REDIS_CONFIG_temp.get('REDIS_MAX_CONNECTIONS'),
                 password=REDIS_CONFIG_temp.get('REDIS_PASSWD'), decode_responses=True)

def getRedisValue(redis_key=None,key=None,conntype=None,oper='select'):
    '''
    :param key:
    :param conntype: 区分不同的redis连接,暂时没用
    :param oper:如果是delete，则做删除操作。目前只支持delete，select
    :return:select->获取所有匹配到key的值
    '''
    flag=0
    redis_db_conn=redis_conn(redis_key)
    if 'select' in key or 'from' in key:
        raise Exception('在redis看来不是有效的key',key)
    redis_value = defaultdict()
    uuid_redis_result=redis_db_conn.keys(key.strip())
    print('模糊匹配到的所有key:',uuid_redis_result)
    if uuid_redis_result and oper=='delete':
        for i in uuid_redis_result:
            redis_db_conn.delete(i)
        return 'delete succ'
    #print(uuid_redis_result)
    if not uuid_redis_result:
        print("[{key}]模糊没有匹配到数据，返回0".format(key=key))
        return 0
    #print(uuid_redis_result,key,redis_key_type)
    for i in uuid_redis_result:
        redis_key_type=redis_db_conn.type(i)
        if redis_key_type == 'list':
            redis_value[i]=redis_db_conn.lrange(i,0,300)
            # uuid_redis_result = redis_db_conn.lrange(i)
        elif redis_key_type in ('dict','hash'):
            redis_value[i]=redis_db_conn.hgetall(i)
            for k,v in redis_value[i].items():
                print('前10条记录，redis key[{}]'.format(i),"===>",k,'===>',v)
                flag+=1
                if flag>10:
                    break

            # uuid_redis_result = redis_db_conn.hgetall(i)
        elif redis_key_type=='string':
            #print(i)
            #print(redis_db_conn.get('search_online_feature:243717827731969_sku'))
            redis_value[i]=redis_db_conn.get(i)

    return redis_value

if __name__ == '__main__':
    userUuid='00003a93-2a32-4501-b338-755b6cb1ec49'
    #t=getRedisValue("order_product_graph:179240378044417")
    gid_redis='device_recall_mapping:'+"BC609876-4ED3-4514-BCB3-9649D066641B"
    user_redis='user_recall_mapping:'+"1d0cdee1-85af-4e5b-856e-4a2e453befb6"
    sku_batch="personal_recall_product:1657881287309234854"
    user_batch="1d0cdee1-85af-4e5b-856e-4a2e453befb6"+"personal_recall_product"+"*"

    # dapan_redis='cold_start_cid3_heat_intentions:202207201049'
    # t=getRedisValue('89',dapan_redis,oper='delete1') #,oper='delete'
    # print(t)

    redis_key="product_similarity:2304543819777"
    redis_key="product_correlation:253755595169288"
    sku_list="163979637300224,163979645691904,163979628911616"
    #redis_db=redis_conn('89')
    #redis_db.lpush(redis_key,*sku_list.split(','))
    redis_key="appstart:1d0cdee1-85af-4e5b-856e-4a2e453befb6-2"
    redis_key="price-tracker:stock:9"
    redis_key="nearline_recommend:real-time:user_feature:54ad92ae-d1f1-4dad-a001-38904248fba5"
    redis_key="*yxm-05719a86-5684-401d-a006-a6127eabeabe*"
    redis_key="user:session:yxm-f461d0e0-fa38-4354-93fa-a20c5e0b415a"
    redis_key="user:session:yxm-0c6d8ea3-a7fc-4d58-aabb-cac9bb26bdf1*"
    #redis_key="nearline_recommend:real-time:user_feature:*"
    #redis_key="nearline_recommend:offline:feed_sort_sku_cid3_feature3"
    #print(getRedisValue('yxm',redis_key,oper='delete1'))
    #print(getRedisValue(redis_key='89',key=redis_key))
    # conn=redis_conn('89')
    # print(conn.type(redis_key))
    print(getRedisValue('yxm',key=redis_key))
    print(1290743/(3600*24))





    ## search_fm_offline_feature:{md5(搜索词)}_query_offline
    ## 内部：md5加密


