# -*- coding: utf-8 -*-
# @Time    : 2021/3/25 15:00
# @Author  : wangyinghao
# @FileName: api_environment.py
# @Software: PyCharm
from django.db import models


class APIEnvironment(models.Model):
    """
    API环境设置
    """
    api_environment_name = models.CharField("API环境名称", max_length=200, null=False)
    api_title = models.CharField("API环境标题名称", max_length=200, null=False)
    api_environment_describe = models.TextField("API环境描述", default="", null=True)
    status = models.BooleanField("状态", default=1)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)
    update_time = models.DateTimeField("更新时间", auto_now_add=True)

    def __str__(self):
        return self.api_environment_name


class APIGlobalVariable(models.Model):
    """
    Api环境全局变量
    """
    api_environment = models.ForeignKey(APIEnvironment, on_delete=models.CASCADE)
    api_global_variable_name = models.TextField("全局变量名称", max_length=5000, null=True)
    api_global_variable_value = models.TextField("全局变量值", max_length=5000, null=True)
    api_global_variable_describe = models.TextField("全局变量描述", max_length=5000, null=True)
    create_time = models.DateTimeField("创建时间", auto_now_add=True)
    update_time = models.DateTimeField("更新时间", auto_now_add=True)

    def __str__(self):
        return self.api_global_variable_name
