# -*- coding: utf-8 -*-
# @Time    : 2020/12/9 15:27
# @Author  : wangyinghao
# @FileName: ui_project_list_view.py
# @Software: PyCharm
from django.views.generic import View
from automated_main.utils.http_format import response_success
from automated_main.models.ui_automation.ui_project import UIProject
import arrow


class UiProjectListView(View):

    def get(self, request, *args, **kwargs):
        """
        代表获取所有项目列表
        :param request:
        :param args:
        :param kwargs:
        :return:
        """

        ui_projects = UIProject.objects.all()
        ui_project_list = []

        for ui_project in ui_projects:
            project_dict = {
                "id": ui_project.id,
                "ui_project_name": ui_project.ui_project_name,
                "describe": ui_project.describe,
                "updata_time": arrow.get(str(ui_project.updata_time)).format('YYYY-MM-DD HH:mm:ss'),
                "create_time": arrow.get(str(ui_project.create_time)).format('YYYY-MM-DD HH:mm:ss'),
            }
            ui_project_list.append(project_dict)

        return response_success(ui_project_list)
