# -*- coding: utf-8 -*-
"""
@Time ： 2021/5/27 18:02
@Auth ： WangYingHao
@File ：performance_script.py
@IDE ：PyCharm

"""
from django import forms


class PerformanceScriptForm(forms.Form):
    performance_script_name = forms.CharField(max_length=50,
                                              min_length=1,
                                              required=True,
                                              error_messages={'required': "性能脚本名称不能为空"})

    performance_script = forms.CharField(max_length=5000,
                                         min_length=1,
                                         required=True,
                                         error_messages={'required': "性能脚本不能为空"})

    performance_project_id = forms.CharField(required=False)

    performance_threads = forms.CharField(max_length=5000,
                                          min_length=1,
                                          required=True,
                                          error_messages={'required': "线程数不能为空"})

    performance_ramp_up_time_seconds = forms.CharField(required=True,
                                                       error_messages={'required': "Ramp-Up时间(秒)不能为空"})

    performance_loop_count = forms.CharField(max_length=5000,
                                             min_length=1,
                                             required=False,
                                             error_messages={'required': "循环次数不能为空"})

    performance_scheduler = forms.CharField(max_length=5000,
                                            min_length=1,
                                            required=True,
                                            error_messages={'required': "调度器不能为空"})

    performance_duration = forms.CharField(max_length=5000,
                                           min_length=1,
                                           required=False,
                                           error_messages={'required': "持续时间不能为空"})

    loop_count_forever = forms.CharField(max_length=5000,
                                         min_length=1,
                                         required=False,
                                         error_messages={'required': "超过5000字符"})

    data_set = forms.CharField(max_length=5000,
                               min_length=1,
                               required=False,
                               error_messages={'required': "超过5000字符"})

    performance_data_script = forms.CharField(max_length=5000,
                                              min_length=1,
                                              required=False,
                                              error_messages={'required': "超过5000字符"})
