# -*- coding: utf-8 -*-
# @Time : 2022/8/24 15:27
# @Author : wangyinghao
# @Site : 
# @File : api_yapi_util.py
# @Software: PyCharm
import requests
import json


class ApiYapiServer:

    @staticmethod
    def api_yapi_server_data(yapi_id):

        data = {"email": "yinghao.wang", "password": "wangyinghao123!"}

        header = {
            "Content-Type": "application/json"
        }

        # YaPi登录接口
        r = requests.post(url="http://yapi.quantgroups.com/api/user/login_by_ldap", json=data, headers=header)
        cookie = r.cookies

        yapi_api_url = "http://yapi.quantgroups.com/api/interface/get?id=" + str(yapi_id)
        # YaPi接口数据
        yapi_api_data = requests.get(url=yapi_api_url, headers=header, cookies=cookie).json()

        api_body = {}
        req_query_list = []
        req_headers_dict = {}
        api_parameter_types = 1

        if 'req_body_type' in yapi_api_data['data'].keys():

            req_body_type_data = yapi_api_data['data']['req_body_type']

            if req_body_type_data == "form":
                api_parameter_types = 1
                req_body_form_data = yapi_api_data['data']['req_body_form']

                for req_body_form in req_body_form_data:
                    api_body[req_body_form['name']] = ""

            elif req_body_type_data == "json":
                api_parameter_types = 2

                # 获取YaPi接口 req_body_other
                if 'req_body_other' in yapi_api_data['data'].keys():
                    req_body_other_data = yapi_api_data['data']['req_body_other']
                    req_body_other_data_json = json.loads(req_body_other_data)
                    for properties in req_body_other_data_json['properties'].keys():
                        api_body[properties] = ""
                else:
                    pass
            elif req_body_type_data == "raw":
                api_parameter_types = 1

            # 获取YaPi接口 req_query
            req_query_data = yapi_api_data['data']['req_query']

            if req_query_data == []:
                req_query_dict = {
                    "api_parameter_name": "",
                    "api_must_parameter": "false",
                    "api_parameter_value": "",
                    "api_field_describe": ""
                }
                req_query_list.append(req_query_dict)
            else:
                for req_query in req_query_data:
                    if req_query['required'] == 0:
                        req_query['required'] = "false"
                    else:
                        req_query['required'] = "true"
                    req_query_dict = {
                        "api_parameter_name": req_query['name'],
                        "api_must_parameter": req_query['required'],
                        "api_parameter_value": "",
                        "api_field_describe": ""
                    }

                    req_query_list.append(req_query_dict)

            # 获取YaPi接口 请求头
            req_headers_data = yapi_api_data['data']['req_headers']
            for req_headers in req_headers_data:
                req_headers_dict[req_headers['name']] = req_headers['value']

            # 获取YaPi请求方式
            if yapi_api_data['data']['method'] == "POST":
                yapi_api_data['data']['method'] = 2
            elif yapi_api_data['data']['method'] == "GET":
                yapi_api_data['data']['method'] = 1
            elif yapi_api_data['data']['method'] == "DELETE":
                yapi_api_data['data']['method'] = 4
            elif yapi_api_data['data']['method'] == "PUT":
                yapi_api_data['data']['method'] = 3
            elif yapi_api_data['data']['method'] == "PATCH":
                yapi_api_data['data']['method'] = 5

        else:
            pass

        req_query_parameter = {
            'api_parameter': req_query_list,
            'api_parameter_body': api_body,
            'api_url': yapi_api_data['data']['path'],
            'api_method': yapi_api_data['data']['method'],
            'api_headers': req_headers_dict,
            'api_documentation': yapi_api_url,
            'api_parameter_types': api_parameter_types
        }

        return req_query_parameter


if __name__ == '__main__':
    sen = ApiYapiServer()
    print(sen.api_yapi_server_data(47240))

    # 2646 json
    # 20066 from
