# -*- coding: utf-8 -*-
# @Time : 2021/11/1 19:03
# @Author : wangyinghao
# @File : send_enterprise_wechat.py
# @Software: PyCharm

import datetime
import time
import json
import requests


class SendEnterpriseWechatMsg:

    def get_current_time(self):
        """
        获取当前时间，当前时分秒
        """
        now_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        hour = datetime.datetime.now().strftime("%H")
        mm = datetime.datetime.now().strftime("%M")
        ss = datetime.datetime.now().strftime("%S")
        return now_time, hour, mm, ss

    def sleep_time(self, hour, m, sec):
        """返回总共秒数"""
        return hour * 3600 + m * 60 + sec

    def send_msg(self, wx_url, total, passing, succeed, failing, result):
        """艾特全部，并发送指定信息"""

        data_text = (
            "提醒！自动化测试反馈\n请相关同事注意，及时跟进！\n"
            "测试用例总数：%s条；测试用例通过率：%s\n"
            "--------------------运行详情--------------------\n"
            "成功数：%s\n失败数：%s\n查看结果地址：%s\n" % (total, passing, succeed, failing, result)

        )

        data = json.dumps({"msgtype": "text", "text": {"content": data_text, "mentioned_list": ["@all"]}})
        r = requests.post(wx_url, data, auth=('Content-Type', 'application/json'))
        print(r.text)

    def every_time_send_msg(self, interval_h=0, interval_m=0, interval_s=5, special_h="00", special_m="00",
                            mode="special"):
        """每天指定时间发送指定消息"""

        # 设置自动执行间隔时间
        second = self.sleep_time(interval_h, interval_m, interval_s)
        # 死循环
        while 1 == 1:
            # 获取当前时间和当前时分秒
            c_now, c_h, c_m, c_s = self.get_current_time()
            print("当前时间：", c_now, c_h, c_m, c_s)
            if mode == "special":
                if c_h == special_h and c_m == special_m:
                    # 执行
                    print("正在发送...")
                    self.send_msg(send_message)
            else:
                self.send_msg(send_message)
            print("每隔" + str(interval_h) + "小时" + str(interval_m) + "分" + str(interval_s) + "秒执行一次")
            # 延时
            time.sleep(second)


if __name__ == '__main__':
    # wx_url = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=a6f1ce13-2d16-465d-b03e-791fae0f3562"  # 测试机器人1号
    send_message = "测试：测试机器人1号………………………………！"

    a = SendEnterpriseWechatMsg()
    # a.every_time_send_msg(mode="no")
    a.send_msg("sssssss")
