# -*- coding: utf-8 -*-
# @Time : 2021/10/21 17:15
# @Author : wangyinghao
# @Site :
# @File : api_database.py
# @Software: PyCharm
from django import forms


class ApiDatabaseForm(forms.Form):
    api_database_title = forms.CharField(max_length=50,
                                         min_length=2,
                                         required=True,
                                         error_messages={'required': "数据库名称不能为空"})

    api_host = forms.CharField(max_length=2000,
                               min_length=2,
                               required=False,
                               error_messages={'required': "host超过2000字符"})

    api_port = forms.CharField(max_length=2000,
                               min_length=2,
                               required=False,
                               error_messages={'required': "端口号超过2000字符"})

    user = forms.CharField(max_length=2000,
                           min_length=2,
                           required=False,
                           error_messages={'required': "用户名称超过2000字符"})

    password = forms.CharField(max_length=2000,
                               min_length=2,
                               required=False,
                               error_messages={'required': "密码超过2000字符"})
    database = forms.CharField(max_length=2000,
                               min_length=2,
                               required=False,
                               error_messages={'required': "数据库表名超过2000字符"})
